/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('./step'),
    StepEnum = require('./stepenum');

function SecureMsgStep(start_time) {
    Step.call(this);

    this.hash = 0;
    this.opt = 0;
    this.crc = 0;
    this.value = null;

    if(start_time != null) {
        this.start_time = start_time;
    }
};

SecureMsgStep.prototype = new Step();
SecureMsgStep.prototype.constructor = SecureMsgStep;
SecureMsgStep.prototype.getStepType = function () {
    return StepEnum.SECURE_MESSAGE;
};
SecureMsgStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeDecimal(this.hash);
    dout.writeByte(this.opt);
    dout.writeByte(this.crc);
    dout.writeBlob(this.value);
};
SecureMsgStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.hash = din.readDecNumber();
    this.opt = din.readByte();
    this.crc = din.readByte();
    this.value = din.readBlob();
    return this;
};

module.exports = SecureMsgStep;