/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('./step'),
    StepEnum = require('./stepenum');

function ResultSetStep() {
    Step.call(this);

    this.dbc = 0;
    this.sqlhash = 0;
    this.elapsed = 0;
    this.fetch = 0;
};

ResultSetStep.prototype = new Step();
ResultSetStep.prototype.constructor = ResultSetStep;
ResultSetStep.prototype.getStepType = function () {
    return StepEnum.RESULTSET;
};
ResultSetStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.fetch);
    dout.writeDecimal(this.dbc);
    dout.writeDecimal(this.sqlhash);
};
ResultSetStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.elapsed = din.readDecNumber();
    this.fetch = din.readDecNumber();
    this.dbc = din.readDecNumber();
    this.sqlhash = din.readDecNumber();
    return this;
};

module.exports = ResultSetStep;