/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

module.exports = MethodStepX;

var Step = require('./step'),
    StepEnum = require('./stepenum');

function MethodStepX() {
    Step.call(this);

    this.hash = 0;
    this.elapsed = 0;
    this.start_cpu = 0;
    this.start_mem = 0;
    this.stack = [];

};
MethodStepX.prototype = new Step();
MethodStepX.prototype.constructor = MethodStepX;
MethodStepX.prototype.getStepType = function () {
    return StepEnum.METHOD_X;
};
MethodStepX.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeByte(0);
    dout.writeDecimal(this.hash);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.start_cpu);
    dout.writeDecimal(this.start_mem);
    dout.writeIntArray(this.stack);
};
MethodStepX.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    var ver = din.readByte();
    this.hash = din.readDecNumber();
    this.elapsed = din.readDecNumber();
    this.start_cpu = din.readDecNumber();
    this.start_mem = din.readDecNumber();
    this.stack = din.readIntArray();
    return this;
};