/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('./step'),
    StepEnum = require('./stepenum');

function MessageStep(start_time) {
    Step.call(this);
    this.hash = 0;
    this.time = 0;
    this.value = 0;
    this.desc = null;
    this.start_time = start_time || 0;
}

MessageStep.prototype = new Step();
MessageStep.prototype.constructor = MessageStep;
MessageStep.prototype.getStepType = function () {
    return StepEnum.MESSAGE;
};
MessageStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeDecimal(this.hash);
    dout.writeDecimal(this.time);
    dout.writeDecimal(this.value);
    dout.writeText(this.desc);
};
MessageStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.hash = din.readDecNumber();
    this.time = din.readDecNumber();
    this.value = din.readDecNumber();
    this.desc = din.readText();
    return this;
};

module.exports = MessageStep;