/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('./step'),
    StepEnum = require('./stepenum'),
    Long = require('long');

function HttpStepX() {
    Step.call(this);

    this.url = 0;
    this.elapsed = 0;
    this.error = Long.ZERO;
    this.host = 0;
    this.port = 0;

    this.status = 0;
    
    this.start_cpu = 0;
    this.start_mem = 0;
    
    this.stack = [];
    this.callee = null;
};

HttpStepX.prototype = new Step();
HttpStepX.prototype.constructor = HttpStepX;
HttpStepX.prototype.getStepType = function () {
    return StepEnum.HTTPCALL_X;
};
HttpStepX.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeByte(1);
    dout.writeDecimal(this.url);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.error);
    dout.writeDecimal(this.host);
    dout.writeDecimal(this.port);

    dout.writeDecimal(this.status);    
    dout.writeDecimal(this.start_cpu);
    dout.writeDecimal(this.start_mem);
    dout.writeIntArray(this.stack);
    dout.writeDecimal(this.callee);
};
HttpStepX.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    var ver=din.readByte();
    this.url = din.readDecNumber();
    this.elapsed = din.readDecNumber();
    this.error = din.readDecNumber();
    this.host = din.readDecNumber();
    this.port = din.readDecNumber();

    this.status = din.readDecNumber();
    this.start_cpu = din.readDecNumber();
    this.start_mem = din.readDecNumber();

    this.stack = din.readIntArray();
    this.callee = din.readDecLong();
    return this;
};

module.exports = HttpStepX;