/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('./step'),
    StepEnum = require('./stepenum');

function DBCStep() {
    Step.call(this);
    this.hash = 0;
    this.elapsed = 0;
    this.error = 0;
}

DBCStep.prototype = new Step();
DBCStep.prototype.constructor = DBCStep;
DBCStep.prototype.getStepType = function() {
    return StepEnum.DBC;
};
DBCStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeDecimal(this.hash);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.error);
};
DBCStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.hash = din.readDecNumber();
    this.elapsed = din.readDecNumber();
    this.error = din.readDecNumber();
    return this;
};

module.exports = DBCStep;