/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step        = require('./step'),
    StepEnum    = require('./stepenum'),
    Long        = require('long');

function ActiveStackStep(id) {
    Step.call(this);

    this.seq = Long.ZERO;
    this.hasCallStack = false;
    if(id instanceof Long) {
        this.seq = id;
    }
};

ActiveStackStep.prototype = new Step();
ActiveStackStep.prototype.constructor = ActiveStackStep;
ActiveStackStep.prototype.getStepType = function() {
    return StepEnum.ACTIVE_STACK;
};
ActiveStackStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeLong(this.seq);
    dout.writeBoolean(this.hasCallStack);
};
ActiveStackStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.seq = din.readLong();
    this.hasCallStack = din.readBoolean();
    return this;
};

module.exports = ActiveStackStep;