/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var StatError       = require('./stat-error'),
    StatTranx       = require('./stat-tranx'),
    StatSql         = require('./stat-sql'),
    StatHttpc       = require('./stat-httpc'),
    StatRemoteIp    = require('./stat-remote-ip'),
    StatRemoteIpUrl = require('./stat-remote-ipurl'),
    StatUserAgent   = require('./stat-useragent'),
    StatTranxMtCaller   = require('./stat-tx-caller'),
    StatTranxDomain   = require('./stat-tx-domain'),
    StatTranxReferer   = require('./stat-tx-referer'),
    Logger          = require('../logger'),
    DateUtil        = require('./../util/dateutil');

const MILLIS_FIVE_MINUTE = 5 * 60 * 1000;

function TimingSender(){
    this.time = Date.now();
    this.run();
    this.intervalIndex = undefined;
}
TimingSender.prototype.run = function(){
    var lastUnit = getCurrentFiveMinUnit();
    if(this.intervalIndex){
        clearInterval(this.intervalIndex); this.intervalIndex = undefined;
    }
    
    this.intervalIndex = setInterval(function () {
        var nowUnit = getCurrentFiveMinUnit();
        if(nowUnit === lastUnit) { return; }
        try{
            lastUnit = nowUnit;
            var now = DateUtil.currentTime();
            var conf = require('../conf/configure');

            if(conf.stat_enabled) {
                StatTranx.send(now);
                StatSql.send(now);
                StatHttpc.send(now);
                StatRemoteIp.send(now);
                StatRemoteIpUrl.send(now);
                StatUserAgent.send(now);
                StatError.send(now);
                StatTranxDomain.send(now);
                StatTranxMtCaller.send(now);
                StatTranxReferer.send(now);
            } else {
                StatTranx.clear();
                StatSql.clear();
                StatHttpc.clear();
                StatRemoteIp.clear();
                StatRemoteIpUrl.clear();
                StatUserAgent.clear();
                StatError.clear();
                StatTranxDomain.clear();
                StatTranxMtCaller.clear();
                StatTranxReferer.clear();
            }
        }catch(e){
            Logger.printError('WHATAP-997', 'TimingSender (run)', e, true);
        }

    }, 1000);
};

function getCurrentFiveMinUnit() {
    return parseInt(DateUtil.currentTime() / MILLIS_FIVE_MINUTE) * MILLIS_FIVE_MINUTE
}

module.exports = new TimingSender();