/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var IntIntMap           = require('../util/intint-map'),
    StatUserAgentPack   = require('../pack/statuseragent-pack'),
    DataPackSender      = require('../data/datapack-sender'),
    Long                = require('long');

const TABLE_MAX_SIZE = 1000;

function StatUserAgent() {
    if(typeof StatUserAgent.instance === 'object') {
        return StatUserAgent.instance;
    }

    this.table = new StatUserAgentPack();
    this.table.userAgents.setMax(TABLE_MAX_SIZE);

    StatUserAgent.instance = this;
}

StatUserAgent.prototype.incUserAgent = function (userAgent) {
    if(userAgent === 0) {
        return;
    }
    this.table.userAgents.addNoOver(userAgent, 1);
};
StatUserAgent.prototype.send = function (now) {
    if(this.table.userAgents.size() === 0) {
        return;
    }

    var p = this.table;
    p.time = now;
    DataPackSender.sendStatUserAgentPack(p);

    this.table = new StatUserAgentPack();
    this.table.userAgents.setMax(TABLE_MAX_SIZE);

};
StatUserAgent.prototype.clear = function () {
    this.table.userAgents.clear();
};

module.exports = new StatUserAgent();
