/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap       = require('../util/linkedmap'),
    AnyList       = require('../util/anylist'),
    StatGeneralPack   = require('../pack/stat-general-pack'),
    DataPackSender  = require('../data/datapack-sender'),
    Logger          = require('../logger'),
    TimeCount      = require('../pack/time-count');

const TABLE_MAX_SIZE = 5000;

function PK(referer, url) {
    this.referer = referer || 0;
    this.url = url || 0;
}

PK.prototype.hashCode = function () {
    var prime = 31;
    var result = 1;
    result = prime * result + this.referer;
    result = prime * result + this.url;
    return result;
};
PK.prototype.equals = function (other) {
    if(this === other) {
        return  true;
    }
    if(other == null) {
        return false;
    }
    return this.referer === other.referer && this.url === other.url;
};


function StatTranxReferer() {
    if(typeof StatTranxReferer.instance === 'object') {
        return StatTranxReferer.instance;
    }

    this.table = new LinkedMap(TABLE_MAX_SIZE + 1 , 1).setMax(TABLE_MAX_SIZE);
    this.table.create = function (key) {
        if(this.size() >= TABLE_MAX_SIZE) {
            return null;
        }
        return new TimeCount();
    };
    StatTranxReferer.instance = this;
}

StatTranxReferer.prototype.getService = function (referer, url) {
    return this.table.intern(new PK(referer,url));
};
StatTranxReferer.prototype.add = function (referer, url, time, isErr) {
    try {
        var rec = this.getService(referer, url);
        if(rec) {
            rec.count++;
            if(isErr){
                rec.error++;
            }
            rec.time +=time;
        }
    } catch(e) {
        Logger.printError("WHATAP-610", "StatTranxReferer add error", e, false);
    }
};
StatTranxReferer.prototype.send = function (now) {
    if(this.table.size() === 0) {
        return;
    }
    var rsize=this.table.size();
    var referer =new AnyList(AnyList.INT, rsize);
    var url =new  AnyList(AnyList.INT, rsize);
    var count = new  AnyList(AnyList.INT, rsize);
    var error = new  AnyList(AnyList.INT, rsize);
    var time = new  AnyList(AnyList.LONG, rsize);

   var en = this.table.entries();
    for (var i = 0; i<rsize &&  en.hasMoreElements(); i++) {
        var ent = en.nextElement();
        var k = ent.getKey();
        var v = ent.getValue();

        referer.put(i, k.referer);
        url.put(i, k.url);
        count.put(i, v.count);
        error.put(i, v.error);
        time.put(i, v.time);
    }
    this.table.clear();        

    var out = new StatGeneralPack();

    out.put("referer", referer);
    out.put("url", url);
    out.put("count", count);
    out.put("error", error);
    out.put("time", time);

    out.id = "referer";
    out.time = now;
    DataPackSender.sendPack(out);
};
StatTranxReferer.prototype.clear = function () {
    this.table.clear();
};

module.exports = new StatTranxReferer();