/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

 var LinkedMap       = require('../util/linkedmap'),
 AnyList       = require('../util/anylist'),
 StatGeneralPack   = require('../pack/stat-general-pack'),
 DataPackSender  = require('../data/datapack-sender'),
 Logger          = require('../logger'),
 HashUtil        = require('../util/hashutil'),
 StringUtil      = require('../util/string-util'),
 DataTextAgent       = require('../data/datatext-agent'),
 conf        = require('../conf/configure'),
 TimeCount      = require('../pack/time-count');

const TABLE_MAX_SIZE = 5000;

function PK(caller_pcode, caller_okind, caller_spec, caller_url, url) {
 this.caller_pcode = caller_pcode;
 this.caller_okind = caller_okind;
 this.caller_spec = caller_spec ;
 this.caller_url = caller_url;
 this.url = url ;
}

PK.prototype.hashCode = function () {
 if(this._hash_){
     return this._hash_;
 }
 var prime = 31;
 var result = 1;
 result = prime * result + this.caller_pcode;
 result = prime * result + this.caller_okind;
 result = prime * result + this.caller_spec;
 result = prime * result + this.caller_url;
 result = prime * result + this.url;
 this._hash_=result;
 return result;
};
PK.prototype.equals = function (other) {
 if(this === other) {
     return  true;
 }
 if(other == null) {
     return false;
 }
 if(other instanceof PK === false) {
     return false;
 }
 return this.caller_pcode === other.caller_pcode 
 && this.caller_okind === other.caller_okind
 && this.caller_spec === other.caller_spec
 && this.caller_url === other.caller_url
 && this.url === other.url;
};


function StatTranxMtCaller() {
 if(typeof StatTranxMtCaller.instance === 'object') {
     return StatTranxMtCaller.instance;
 }

 this.table = new LinkedMap(TABLE_MAX_SIZE + 1 , 1).setMax(TABLE_MAX_SIZE);
 this.table.create = function (key) {
     if(this.size() >= TABLE_MAX_SIZE) {
         return null;
     }
     return new TimeCount();
 };

 conf.on('stat_mtrace_max_count', function(props){
     StatTranxMtCaller.instance.table.setMax(props);
 })

 StatTranxMtCaller.instance = this;
}

StatTranxMtCaller.prototype.getService = function (caller_pcode, caller_okind, caller_spec, caller_url,url) {
 return this.table.intern(new PK(caller_pcode,caller_okind,caller_spec, caller_url, url));
};
StatTranxMtCaller.prototype.add = function (caller_pcode, caller_spec, caller_url, url, 
 time, isErr) {
 try {
     var rec = this.getService(caller_pcode, caller_spec, caller_url,url);
     if(rec) {
         rec.count++;
         if(isErr){
             rec.error++;
         }
         rec.toime +=time;
     }
 } catch(e) {
     Logger.printError("WHATAP-610", "StatTranxMtCaller add error", e, false);
 }
};
StatTranxMtCaller.prototype.send = function (now) {
 if(this.table.size() === 0) {
     return;
 }
 var mtrace_spec_hash = 0;
 // if(conf.mtrace_spec) {
 //     mtrace_spec_hash = HashUtil.hash(conf.mtrace_spec);
 //     DataTextAgent.MTRACE_SPEC.add(mtrace_spec_hash,conf.mtrace_spec);
 // }
 if( StringUtil.isNotEmpty(conf.mtrace_spec) ){
     DataTextAgent.MTRACE_SPEC.add(conf.mtrace_spec_hash, conf.mtrace_spec);
 }        
         
 var rsize=this.table.size();
 var caller_pcode =new AnyList(AnyList.LONG, rsize); /*pcode=LONG*/
 var caller_okind =new AnyList(AnyList.INT, rsize);
 var caller_spec =new  AnyList(AnyList.INT, rsize);
 var caller_url =new  AnyList(AnyList.INT, rsize);
 var spec =new  AnyList(AnyList.INT, rsize);
 var url =new  AnyList(AnyList.INT, rsize);
 var count = new  AnyList(AnyList.INT, rsize);
 var error = new  AnyList(AnyList.INT, rsize);
 var time = new  AnyList(AnyList.LONG, rsize);

var en = this.table.entries();
 for (var i = 0; i<rsize && en.hasMoreElements(); i++) {
     var ent = en.nextElement();
     var k = ent.getKey();
     var v = ent.getValue();

     caller_pcode.put(i, k.caller_pcode);
     caller_okind.put(i, k.caller_okind);
     caller_spec.put(i, k.caller_spec);
     caller_url.put(i, k.caller_url);
     spec.put(i, mtrace_spec_hash);
     url.put(i, k.url);
     count.put(i, v.count);
     error.put(i, v.error);
     time.put(i, v.time);
 }
 this.table.clear();        

 var out = new StatGeneralPack();
 out.put("caller_pcode", caller_pcode);
 out.put("caller_okind", caller_okind);
 out.put("caller_spec", caller_spec);
 out.put("caller_url", caller_url);
 out.put("spec", spec);
 out.put("url", url);
 out.put("count", count);
 out.put("error", error);
 out.put("time", time);

 out.id = "mt";
 out.time = now;
         
 DataPackSender.sendPack(out);
};
StatTranxMtCaller.prototype.clear = function () {
 this.table.clear();
};

module.exports = new StatTranxMtCaller();