/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var IntKeyLinkedMap     = require('../util/intkey-linkedmap'),
    TransactionRec      = require('../pack/statservice-rec'),
    StatServicePack     = require('../pack/statservice-pack'),
    StatServicePack1     = require('../pack/statservice-pack1'),
    conf        = require('./../conf/configure'),
    Logger          = require('../logger'),
    DataPackSender      = require('../data/datapack-sender')
    
const TABLE_MAX_SIZE = 5000;

function StatTranx() {
    if(typeof StatTranx.instance === 'object') {
        return StatTranx.instance;
    }

    this.table = new IntKeyLinkedMap(TABLE_MAX_SIZE + 1, 1).setMax(TABLE_MAX_SIZE);
    this.table.create = function (hash) {
        if(this.isFull()) {
            return null;
        }
        var rec = new TransactionRec();
        rec.setUrlHash(hash);
        rec.time_min = Number.MAX_VALUE;
        return rec;
    };

    StatTranx.instance = this;
}

StatTranx.prototype.getService = function (hash) {
    return this.table.intern(hash);
};
StatTranx.prototype.send = function (now) {
    if(this.table.size() === 0) {
        return;
    }
    var p = undefined;
    if(conf.stat_service1_enabled){
        p = new StatServicePack1().setRecords(this.table.size(), this.table.values());
        p.spec = conf.mtrace_spec_hash;
    }else{
        p = new StatServicePack().setRecords(this.table.size(), this.table.values());
    }
    p.time = now;
    this.table.clear();
    DataPackSender.sendStatServicePack(p);
};
StatTranx.prototype.clear = function () {
    this.table.clear();
};

module.exports = new StatTranx();