/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

const TABLE_MAX_SIZE = 5000;

var LinkedMap    = require('../util/linkedmap'),
    SqlRec              = require('../pack/statsql-rec'),
    StatSqlPack         = require('../pack/statsql-pack'),
    DataPackSender      = require('../data/datapack-sender');

function StatSql() {
    if(typeof StatSql.instance === 'object') {
        return StatSql.instance;
    }

    this.table = new LinkedMap(TABLE_MAX_SIZE + 1, 1).setMax(TABLE_MAX_SIZE);
    this.table.hash = function (k) {
        if(k._hash_){
            return k._hash_;
        }
        var result = 1;
        result = 31 * result + k.dbc;
        result = 31 * result + k.sql;
        
        k._hash_=result;
        return result;
    }
    this.table.equals = function (k1,k2) {
        return k1.dbc === k2.dbc && k1.sql === k2.sql;
    }
    this.table.create = function (key) {
        if(this.isFull()) {
            return null;
        }
        var rec = new SqlRec();
        rec.dbc = key.dbc;
        rec.sql = key.sql;
        rec.time_min = Number.MAX_SAFE_INTEGER;
        return rec;
    };

    StatSql.instance = this;
}
StatSql.prototype.getSql = function (dbc, sql) {
    var key = {dbc: dbc , 
               sql: sql
              };
    return this.table.intern(key);
};
StatSql.prototype.addFetch = function (dbc, sql, fetch, fetchTime) {
    if(sql === 0) {
        return;
    }
    var r = this.getSql(dbc, sql);
    if(r != null) {
        r.fetch_count += fetch;
        r.fetch_time += fetchTime;
    }
};
// StatSql.prototype.addUpdate = function (dbc, sql, updated) {
//     if(sql === 0) {
//         return;
//     }
//     var r = this.getSql(dbc, sql);
//     if(r != null) {
//         r.update_count = r.update_count.add(updated);
//     }
// };

StatSql.prototype.addSqlTime = function (urlHash, dbc,  sql, time, isErr, updated) {
    
    urlHash = urlHash || 0;
    sql = sql || 0;
    time = time || 0;
    updated = updated || 0;
    
    if(sql === 0) {
        return;
    }
    var sqlRec = this.getSql(dbc, sql);
    if(sqlRec != null) {
        sqlRec.count_total++;
        sqlRec.time_sum +=time;
        sqlRec.time_std += time*time;
        sqlRec.time_min = Math.min(sqlRec.time_min, time);
        sqlRec.time_max = Math.max(sqlRec.time_max, time);
        if(isErr) {
            sqlRec.count_error++;
        }
        sqlRec.update_count +=updated;
        sqlRec.service = urlHash;
    }
};
StatSql.prototype.send = function (now) {
    if(this.table.size() === 0) {
        return;
    }

    var p = new StatSqlPack().setRecords(this.table.size(), this.table.values());
    p.time = now;
    this.table.clear();
    DataPackSender.sendStatSqlPack(p);
};
StatSql.prototype.clear = function () {
    this.table.clear();
};


//싱글톤으로 동작해야한다. 
module.exports = new StatSql();