const StatGeneralPack = require('../pack/stat-general-pack');
const LongKeyLinkedMap = require('../util/longkey-linkedmap');
const TimeCount = require('../pack/time-count');
const conf = require('../conf/configure');
const BitUtil = require('../util/bitutil');
const ZipProfile = require('../data/zipprofile');
const DataPackSender = require('../data/datapack-sender');
const AnyList       = require('../util/anylist');

var TABLE_MAX_SIZE = 10000;

function StatRemoteIpurl() {
    if (typeof StatRemoteIpurl.instance === 'object') {
        return StatRemoteIpurl.instance;
    }

    this.TABLE_MAX_SIZE = TABLE_MAX_SIZE;
    this.table = new LongKeyLinkedMap(TABLE_MAX_SIZE + 1, 1).setMax(TABLE_MAX_SIZE);
    this.table.create = function (key) {
        return new TimeCount();
    };

    StatRemoteIpurl.instance = this;
}

StatRemoteIpurl.prototype.getService = function (ip, url_hash) {
    var key = BitUtil.composite(ip, url_hash);
    if (this.table.size() < conf.getProperty('stat_ipurl_max_count', 10000)) {
        return this.table.intern(key);
    } else {
        return this.table.get(key);
    }
};

StatRemoteIpurl.prototype.send = function (now) {
    if (this.table.size() === 0) return;

    var currTable = this.table;
    var sz = Math.max(this.TABLE_MAX_SIZE, conf.getProperty('stat_ipurl_max_count', 10000));
    this.table = new LongKeyLinkedMap(sz + 1, 1).setMax(conf.getProperty('stat_ipurl_max_count', 10000));
    this.table.create = function (key) {
        return new TimeCount();
    };

    var rsize = this.table.size();
    var ip = new AnyList(AnyList.INT, rsize);
    var url = new AnyList(AnyList.INT, rsize);
    var count = new AnyList(AnyList.INT, rsize);
    var error = new AnyList(AnyList.INT, rsize);
    var time = new AnyList(AnyList.LONG, rsize);

    var entries = currTable.entries();
    var i = 0;
    while(entries.hasMoreElements()){
        var ent = entries.nextElement();
        var k = ent.getKey();
        var v = ent.getValue();

        ip.put(i, BitUtil.getHigh(k));
        url.put(i, BitUtil.getLow(k));
        count.put(i, v.count);
        error.put(i, v.error);
        time.put(i, v.time);
        i++;
    }

    const out = new StatGeneralPack();
    out.put("ip", ip);
    out.put("url", url);
    out.put("count", count);
    out.put("error", error);
    out.put("time", time);

    out.id = "ip-url";
    out.time = now;

    DataPackSender.sendStatRemoteIpUrlPack(out);
};

StatRemoteIpurl.prototype.clear = function () {
    this.table.clear();
};

StatRemoteIpurl.prototype.size = function () {
    return this.table.size();
};

module.exports = new StatRemoteIpurl();
