/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var StatRemoteIpPack    = require('../pack/statremote-pack'),
    DataPackSender      = require('../data/datapack-sender');

var TABLE_MAX_SIZE = 70000;

function StatRemoteIp() {
    if(typeof StatRemoteIp.instance === 'object') {
        return StatRemoteIp.instance;
    }

    this.table = new StatRemoteIpPack();
    this.table.iptable.setMax(TABLE_MAX_SIZE);

    StatRemoteIp.instance = this;
}

StatRemoteIp.prototype.incRemoteIp = function (ip) {
    if(ip) {
        this.table.iptable.addNoOver(ip,1);
    }
};
StatRemoteIp.prototype.send = function (now) {
    if(this.table.iptable.size() === 0) {
        return;
    }

    var p = this.table;
    p.time = now;
    DataPackSender.sendStatRemoteIpPack(p);

    this.table = new StatRemoteIpPack();
    this.table.iptable.setMax(TABLE_MAX_SIZE);
};
StatRemoteIp.prototype.clear = function () {
    this.table.iptable.clear();
};

module.exports = new StatRemoteIp();


