/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var ErrorData = require('../util/errordata'),
    BitUtil = require('../util/bitutil'),
    ErrorSnapPack1 = require('../pack/errorsnap-pack'),
    StatErrorPack = require('../pack/staterror-pack').StatErrorPack,
    ErrorRec = require('../pack/staterror-pack').ErrorRec,
    hashUtil = require('../util/hashutil'),
    LinkedMap = require('../util/linkedmap'),
    DataTextAgent = require('../data/datatext-agent'),
    Logger          = require('../logger'),
    Long = require('long');

    
var DataPackSender = require('../data/datapack-sender');

var ERROR_SNAP_SEQ = Long.fromNumber(Date.now());
var TABLE_MAX_SIZE = 1000;

function StatError() {
    this.conf = require('../conf/configure');
    this.table = new LinkedMap(TABLE_MAX_SIZE + 1, 1).setMax(TABLE_MAX_SIZE);
    this.table.hash = function (k) {
        if(k._hash_){
            return k._hash_;
        }
        var result = 1;
        result = 31 * result + k.class;
        result = 31 * result + k.service;
        
        k._hash_=result;
        return result;
    }
    this.table.equals = function (k1,k2) {
        return k1.class === k2.class && k1.service === k2.service;
    }
    this.table.create=function(key){
        if(this.isFull()) {
            return null;
        }
        rec = new ErrorRec();
        rec.classHash = key.class;
        rec.service = key.service;
        return rec;
    }
    this.error = {};
}

function nextErrorSnapSeq(){
    ERROR_SNAP_SEQ = ERROR_SNAP_SEQ.add(1);
    return ERROR_SNAP_SEQ;
}

// StatError.prototype.addErrorForStep = function(thr, dbc, service, steps, stackTrace) {
//     var error_data = new ErrorData(thr, 0, txUrlHash, profile, true); // notdol: error데이터 객체를 만드는 의미가 없음
//     var error_snap_pack = new ErrorSnapPack1();                        // notdol: errorSnappack을 만드는 의미가 없음
//     error_snap_pack.setProfile(error_data.profile);

//     var rec = this.table.get({class: dbc, service : service});
//     if(rec){
//         rec.count++;
//     }
// };
StatError.prototype.addError = function(class1, msg, txUrlHash, appendTextType, appendTextHash) {
    try {
        if(typeof class1 ==='number'){
            class1 = class1.toString();
        }
        var classHash = hashUtil.hashFromString(class1);
        DataTextAgent.ERROR.add(classHash, class1);

        var msgHash = hashUtil.hashFromString(msg);
        DataTextAgent.ERROR.add(msgHash, msg);

        var key = {class: classHash, service : txUrlHash};
        var rec = this.table.intern(key);
        if (rec) {
            rec.msg = msgHash;
            rec.count++;
            if (appendTextType && rec.snapSeq == 0 && this.conf.error_snap_enabled===true) {
                var p = new ErrorSnapPack1();
                p.seq = nextErrorSnapSeq();
                rec.snapSeq = p.seq;
                rec.msg = msgHash;
            
                p.append_type = appendTextType;
                p.append_hash = appendTextHash;
                DataPackSender.sendErrorSnapPack(p);
            }
        }
        return BitUtil.composite(classHash,msgHash);
    } catch(e) {
        Logger.printError('WHATAP-996', 'StatError (addError)', e, false);
    }
    return Long.ZERO;
};
StatError.prototype.send = function(now) {
    if (this.table.size() === 0)
        return;

    var statError = new StatErrorPack().setRecords(this.table.size(), this.table.values());
    statError.time = now;
    this.table.clear();

    DataPackSender.sendStatErrorPack(statError);
};
StatError.prototype.clear = function () {
    this.table.clear();
};

module.exports = new StatError();
