/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx'),
    Long        = require('long') ,
    EventLevel  = require('../data/event-level');
function TxRecord() {
    this.seq = Long.ZERO;
    this.endTime =0;
    this.service = 0;
    this.elapsed = 0;
    this.error = Long.ZERO;
    this.cpuTime = 0;
    this.malloc = 0;

    this.sqlCount = 0;
    this.sqlTime = 0;
    this.sqlFetchCount = 0;
    this.sqlFetchTime = 0;

    this.httpcCount = 0;
    this.httpcTime = 0;
    this.active = false;
    this.steps_data_pos = 0;
    this.cipher = 0;

    this.ipaddr = 0;
    this.userid = Long.ZERO;
    this.userAgent = 0;
    this.referer = 0;
    this.status = 0;

    this.mtid = Long.ZERO;
    this.mdepth = 0;
    this.mcaller = Long.ZERO;
    this.mcaller_txid = Long.ZERO;

    this.mcaller_pcode = 0;
    this.mcaller_okind = 0;
    this.mcaller_oid = 0;
    this.mcaller_spec = 0;
	this.mcaller_url = 0;
    this.mthis_spec = 0;
    
    this.http_method = 0;

    this.domain = 0;
    this.fields = [];

    this.login=0;
	this.errorLevel=0;

	this.oid=0;
    this.okind=0;
	this.onode=0;
    
    this.custid=null;
    this.dbcTime=0;
    this.apdex=0;

    this.mcallerStepId = Long.ZERO;
    this.originUrl = null;    
}
TxRecord.prototype.getServiceType = function() {return 0;};

TxRecord.prototype.write = function(dout) {
    dout.writeByte(10); //version

    var o = new DataOutputX();
    o.writeLong(this.seq);
    o.writeDecimal(this.endTime);
    o.writeDecimal(this.service);
    o.writeDecimal(this.elapsed);
    o.writeDecimal(this.error);
    o.writeDecimal(this.cpuTime);
    o.writeDecimal(this.malloc);
    
    o.writeDecimal(this.sqlCount);
    o.writeDecimal(this.sqlTime);
    o.writeDecimal(this.sqlFetchCount);
    o.writeDecimal(this.sqlFetchTime);
    
    o.writeDecimal(this.httpcCount);
    o.writeDecimal(this.httpcTime);
    
    o.writeBoolean(this.active);
    o.writeDecimal(this.steps_data_pos);
    o.writeDecimal(this.cipher);

    o.writeInt(this.ipaddr);
    o.writeDecimal(this.userid);
    o.writeDecimal(this.userAgent);
    o.writeDecimal(this.referer);
    o.writeDecimal(this.status);

    if(this.mtid.isZero()==false){
        o.writeByte(1);
        o.writeDecimal(this.mtid);
        o.writeDecimal(this.mdepth);
        o.writeDecimal(this.mcaller);
    }else{
        o.writeByte(0);
    }
    if(this.mcaller_pcode!=0) {
        o.writeByte(6);
        o.writeDecimal(this.mcaller_pcode);
        o.writeDecimal(this.mcaller_okind);
        o.writeDecimal(this.mcaller_oid);
        o.writeDecimal(this.mcaller_spec);
        o.writeDecimal(this.mcaller_url);
        o.writeDecimal(this.mthis_spec);//보통 0, 서버에서 셋팅
     }else {
        o.writeByte(0);
     }

    o.writeByte(this.http_method);
    o.writeDecimal(this.domain);
    
    if (this.fields == null || this.fields.length==0) {
        o.writeByte(0);
    } else {
        var sz = this.fields.length;
        o.writeByte(sz);
        for (var i = 0; i < sz; i++) {
            o.writeByte(this.fields[i].id);
            o.writeText(this.fields[i].value);
        }
    }
    o.writeDecimal(this.login);
    o.writeByte(this.errorLevel);

    // 2018.12.28
    o.writeDecimal(this.oid);
    o.writeDecimal(this.okind);
    o.writeDecimal(this.onode);
    
    o.writeText(this.custid);
    o.writeDecimal(this.dbcTime);
    o.writeByte(this.apdex);

    o.writeDecimal(this.mcallerStepId);
    o.writeText(this.originUrl);

    ////////////// BLOB ///////////////
    dout.writeBlob(o.toByteArray());
};

TxRecord.prototype.read = function(din) {
    var ver = din.readByte();
    if(ver <10){
        throw new Error('TxRecord has invalid version='+ver);
    }
    var i = new DataInputX(din.readBlob());
    this.seq = i.readLong();
    this.endTime = i.readDecNumber();
    this.service =  i.readDecNumber();
    this.elapsed = i.readDecNumber();
    this.error = i.readDecimal();
  
    this.cpuTime = i.readDecNumber();
    this.malloc = i.readDecNumber();
    
    this.sqlCount = i.readDecNumber();
    this.sqlTime = i.readDecNumber();
    this.sqlFetchCount = i.readDecNumber();
    this.sqlFetchTime = i.readDecNumber();
    
    this.httpcCount = i.readDecNumber();
    this.httpcTime = i.readDecNumber();
    
    this.active = i.readBoolean();
    this.steps_data_pos = i.readDecNumber();
    this.cipher = i.readDecNumber();

    this.ipaddr = i.readInt();
    this.userid = i.readDecLong();
    this.userAgent = i.readDecNumber();
    this.referer = i.readDecNumber();
    this.status = i.readDecNumber();

    if(i.readByte() >0){
        this.mtid = i.readDecLong();
        this.mdepth = i.readDecNumber();
        this.mcaller_txid = i.readDecLong();
    }
   
    switch (i.readByte()) {
		case 1:
			this.mcaller_pcode = i.readDecNumber();
			break;
		case 3:
			this.mcaller_pcode = i.readDecNumber();
			this.mcaller_spec = i.readDecNumber();
			this.mcaller_url = i.readDecNumber();
			break;
		case 4:
			this.mcaller_pcode = i.readDecNumber();
			this.mcaller_spec = i.readDecNumber();
			this.mcaller_url = i.readDecNumber();
			this.mthis_spec = i.readDecNumber();
			break;
		case 5:
			this.mcaller_pcode = i.readDecNumber();
			this.mcaller_oid = i.readDecNumber();
			this.mcaller_spec = i.readDecNumber();
			this.mcaller_url = i.readDecNumber();
			this.mthis_spec = i.readDecNumber();
			break;
		case 6:
			this.mcaller_pcode = i.readDecNumber();
			this.mcaller_okind = i.readDecNumber();
			this.mcaller_oid = i.readDecNumber();
			this.mcaller_spec = i.readDecNumber();
			this.mcaller_url = i.readDecNumber();
			this.mthis_spec = i.readDecNumber();
			break;
		}
    this.http_method = i.readByte();
    this.domain = i.readDecNumber();
    
    var n = i.readByte();
    if (n > 0) {
        this.fields = new Array(n);
        for (var c = 0; c < n; c++) {
            var id = i.readByte();
            var value = i.readText();
            this.fields[i] = {
                id: id,
                value: value
            };
        }
    }

    if (i.available() > 0) {
        this.login = i.readDecNumber();
    }
    if (i.available() > 0) {
        this.errorLevel = i.readByte();
    }  else {
        if (this.error != 0) {
            this.errorLevel = EventLevel.WARNING;
        }
    }
    if(i.available()>0) {
        this.oid = i.readDecNumber();
        this.okind = i.readDecNumber();
        this.onode = i.readDecNumber();
    }
    
    if (i.available() > 0) {
        this.custid = i.readText();
    }
    if (i.available() > 0) {
        this.dbcTime = i.readDecNumber();
    }
    if (i.available() > 0) {
        this.apdex = i.readByte();
    }
    
    if(i.available()>0) {
        this.mcallerStepId=i.readDecNumber();
        this.originUrl=i.readText();
    }		

    return this;
};

TxRecord.prototype.toBytes = function() {
    var dout = new DataOutputX();
    this.write(dout);
    return dout.toByteArray();
};

TxRecord.prototype.toObject = function(b) {
    var din = new DataInputX(b); 
    this.read(din);
    return service;
};

TxRecord.HTTP_METHOD={"GET":1,"POST":2,"PUT":3,"DELETE":4,"PATCH":5,"OPTIONS":6,"HEAD":7,"TRACE":8};
TxRecord.WEB_GET = 1;
TxRecord.WEB_POST = 2;
TxRecord.WEB_PUT = 3;
TxRecord.WEB_DELETE = 4;
TxRecord.WEB_PATCH = 5;
TxRecord.WEB_OPTIONS = 6;
TxRecord.WEB_HEAD = 7;
TxRecord.WEB_TRACE = 8;

module.exports = TxRecord;