/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var fs   = require('fs'),
    path = require('path'),
    PlugIn = require('./plugin'),
    Logger = require('../logger');

var fileName = ['appservicestart', 'appserviceend', 'httpservicestart', 'httpserviceend', 'httpcall'];

function PluginLoaderManager() {
    this.loaded = false;
    this.interval = null;
    this.module_holder;
}

PluginLoaderManager.prototype.start = function () {
    var self = this;

    this.module_holder = {};
    fileName.forEach(function (name) {
        var script = name + '.js';
        self.module_holder[name] = new PlugIn(script);
    });

    self.run(function () {
        self.interval = setInterval(function () {
            self.run();
        }, 5000);
    });
};
PluginLoaderManager.prototype.do = function (moduleName) {
    try {
        if(this.module_holder && this.module_holder[moduleName]) {
            this.module_holder[moduleName]._process(arguments[1], arguments[2], arguments[3]);
        }
    } catch(e) {
        Logger.printError('WHATAP-700', 'Plugin Error', e, false);
    }
};
PluginLoaderManager.prototype.run = function (cb) {
    var self = this;

    fileName.forEach(function (name) {
        self.module_holder[name].create();
    });

    if(cb) { cb(); }
};
PluginLoaderManager.prototype.stop = function () {
    clearInterval(this.interval);
};

module.exports = new PluginLoaderManager();