const conf = require('../conf/configure');

class PiiItem {
    constructor(field, pattern) {
        if (pattern === undefined) {
            pattern = field;
            field = null;
        }

        this.field = field;
        this.isContent = !field || field === 'content';
        this.expr = pattern;
        this.pattern = new RegExp(pattern);
    }

    mask(pack) {
        if(!pack.content){
            return;
        }
        if(this.pattern.test(pack.content)){
            this.pattern.lastIndex = 0;
            pack.content = pack.content.replace(this.pattern, conf.getProperty('pii_mask_logsink_replace', 'pii-included'));
        }
    }

    hasMatch(s) {
        return this.pattern.test(s);
    }
}

module.exports = PiiItem;