/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack'),
    TxRecord = require('../service/tx-record'),
    Step = require('../step/step'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx');

function ZipPack() {
    Pack.call(this);
    this.records = [];
    this.recordCount = null;
    this.status = 0;
}
ZipPack.prototype = new Pack();
ZipPack.prototype.constructor = ZipPack;
ZipPack.prototype.toString = function() {
    var text = 'ZipPack ' + Pack.prototype.toString.call(this);
    return text;
};
ZipPack.prototype.getPackType = function () {
    return PackEnum.ZIP;
};
ZipPack.prototype.write = function (dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeByte(this.status);
    dout.writeDecimal(this.recordCount);
    dout.writeBlob(this.records);
}
ZipPack.prototype.read = function (din) {
    Pack.prototype.read.call(this, din);
    this.status = din.readByte();
    this.recordCount = din.readDecimal();
    this.records = din.readBlob();
    return this;
}
ZipPack.prototype.setRecords = function (items, size) {
    if(size) this.recordCount = size;
    else this.recordCount = items.length;

    var o = new DataOutputX();
    for(let i = 0; i < items.length; i++){
        o.writePack(items[i]);
    }
    this.records = o.toByteArray();
    return this;
}
ZipPack.prototype.getRecords = function () {
    var items = [];
    if(!this.records) {
        return null;
    }
    var dataInputX = new DataInputX(this.records);
    for(let i = 0; i < this.recordCount; i++){
        var p = dataInputX.readPack();
        p.pcode = this.pcode;
        p.oid = this.oid;
        p.okind = this.okind;
        p.onode = this.onode;
        items.push(p);
    }
    return items;
}

module.exports = ZipPack;