/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack = require('./pack'),
    PackEnum = require('./packenum');

function TextRec(type, hash, text){
    this.type = type || 0;
    this.hash = hash || 0;
    this.text = text || '';
}

function TextPack(){
    Pack.call(this);
    this.records = []; /*List<TextRec>*/
}

TextPack.prototype = new Pack();
TextPack.prototype.constructor = TextPack;
TextPack.prototype.getPackType = function () {
    return PackEnum.TEXT;
};
TextPack.prototype.write = function(dout){
    Pack.prototype.write.call(this, dout);
    dout.writeDecimal(this.records.length);
    this.records.forEach(function(r) {
        dout.writeByte(r.type);
        dout.writeInt(r.hash);
        dout.writeText(r.text);
    });
};
TextPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);

    var size = din.readDecNumber();
    for (var i = 0; i < size; i++) {
        var r = new TextRec();
        r.type = din.readByte();
        r.hash = din.readInt();
        r.text = din.readText();
        this.records.push(r);
    }
    return this;
};

exports.TextRec = TextRec;
exports.TextPack = TextPack;