/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack        = require('./pack'),
    PackEnum    = require('./packenum'),
    IntIntMap   = require('../util/intint-map');

function StatUserAgentPack() {
    Pack.call(this);
    this.userAgents = new IntIntMap();
}

StatUserAgentPack.prototype = new Pack();
StatUserAgentPack.prototype.constructor = StatUserAgentPack;
StatUserAgentPack.prototype.getPackType = function () {
    return PackEnum.STAT_USER_AGENT;
};
StatUserAgentPack.prototype.write = function (dout) {
    Pack.prototype.write.call(this, dout);

    dout.writeDecimal(this.userAgents.size());
    var en = this.userAgents.entries();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        dout.writeInt(e.getKey());
        dout.writeInt(e.getValue());
    }
};
StatUserAgentPack.prototype.read = function (din) {
    Pack.prototype.read.call(this, din);
    var cnt = din.readDecNumber();
    this.userAgents = new IntIntMap();
    for(var i=0; i<cnt; i++) {
        var ip = din.readInt();
        var count = din.readInt();
        this.userAgents.put(ip, count);
    }
    return this;
};

module.exports = StatUserAgentPack;