/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var BitUtil     = require('../util/bitutil');
    
function SqlRec() {
    this.dbc = 0;
    this.sql = 0;
    this.sql_crud = 0;
    this.count_total = 0;
    this.count_error = 0;
    //this.count_actived = 0;
    this.time_sum = 0;
    this.time_std = 0;
    this.time_min = 0;
    this.time_max = 0;
    this.fetch_count = 0;
    this.fetch_time = 0;
    this.update_count = 0;
    this.service = 0;
}

SqlRec.prototype.merge = function (other) {
    this.count_total += other.count_total;
    this.count_error += other.count_error;
    //this.count_actived += other.count_actived;
    this.time_sum +=other.time_sum;
    this.time_std = other.time_std;
    this.time_max = Math.max(this.time_max, other.time_max);
    this.time_min = Math.min(this.time_min, other.time_min);
    this.fetch_count += other.fetch_count;
    this.fetch_time += other.fetch_time;
    this.update_count +=other.update_count;
};
SqlRec.prototype.key = function () {
    return BitUtil.composite(this.dbc, this.sql);
};

SqlRec.prototype.write = function (dout, m) {
    dout.writeInt(this.dbc);
    dout.writeInt(this.sql);
    dout.writeByte(this.sql_crud);
    dout.writeDecimal(this.count_total);
    dout.writeDecimal(this.count_error);
    dout.writeDecimal(-1);
    dout.writeDecimal(this.time_sum);
    dout.writeDecimal(this.time_std);
    dout.writeDecimal(this.time_min);
    dout.writeDecimal(this.time_max);
    dout.writeDecimal(this.fetch_count);
    dout.writeDecimal(this.fetch_time);
    dout.writeDecimal(this.update_count);

    dout.writeDecimal(this.service);
};
SqlRec.prototype.read = function (din) {
    this.dbc = din.readInt();
    this.sql = din.readInt();
    this.sql_crud = din.readByte();
    this.count_total = din.readDecNumber();
    this.count_error = din.readDecNumber();
    
    var ver = din.readDecNumber();

    this.time_sum = din.readDecNumber();
    this.time_std = din.readDecNumber();
    this.time_min = din.readDecNumber();
    this.time_max = din.readDecNumber();
    this.fetch_count = din.readDecNumber();
    this.fetch_time = din.readDecNumber();
    this.update_count = din.readDecNumber();
    if(ver >=0){
        return this;
    }
    this.service = din.readDecNumber();
    return this;
};

SqlRec.writeRec = function (dout, m) {
    dout.writeInt(m.dbc);
    dout.writeInt(m.sql);
    dout.writeByte(m.sql_crud);
    dout.writeDecimal(m.count_total);
    dout.writeDecimal(m.count_error);
    dout.writeDecimal(-1);
    dout.writeDecimal(m.time_sum);
    dout.writeDecimal(m.time_std);
    dout.writeDecimal(m.time_min);
    dout.writeDecimal(m.time_max);
    dout.writeDecimal(m.fetch_count);
    dout.writeDecimal(m.fetch_time);
    dout.writeDecimal(m.update_count);

    dout.writeDecimal(m.service);
};

module.exports = SqlRec;
