/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack        = require('./pack'),
    PackEnum    = require('./packenum'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX  = require('../io/data-inputx'),
    SqlRec     = require('./statsql-rec');

function StatSqlPack() {
    Pack.call(this);
    this.records = [];
    this.record_count = 0;
    return this;
}

StatSqlPack.prototype = new Pack();
StatSqlPack.prototype.constructor = StatSqlPack;
StatSqlPack.prototype.getPackType = function () {
    return PackEnum.STAT_SQL;
};

StatSqlPack.prototype.write = function (dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeBlob(this.records);
    dout.writeDecimal(this.record_count);
};
StatSqlPack.prototype.read = function (din) {
    Pack.prototype.read.call(this, din);
    this.records = din.readBlob();
    this.record_count = din.readDecNumber();
    return this;
};
StatSqlPack.prototype.setRecords = function (size, items) {
    var dout = new DataOutputX();
    dout.writeShort(size);
    while(items.hasMoreElements()) {
        SqlRec.writeRec(dout, items.nextElement());
        //items.nextElement().write(dout);
    }
    /*
    for(var i=0; i<size; i++) {
        items.nextElement().write(dout);
    }
    */
    this.records = dout.toByteArray();
    this.record_count = size;
    return this;
};
StatSqlPack.prototype.getRecords = function () {
    var items = [];
    if(this.records == null) {
        return items;
    }

    var din = new DataInputX(this.records);
    var size = din.readShort();
    for(var i=0; i<size; i++) {
        var m = new SqlRec().read(din);
        items.push(m);
    }
    return items;
};


module.exports = StatSqlPack;
