/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack            = require('./pack'),
    PackEnum        = require('./packenum'),
    IntKeyLinkedMap = require('../util/intkey-linkedmap'),
    DataOutputX     = require('../io/data-outputx'),
    DataInputX      = require('../io/data-inputx'),
    TimeCount      = require('./time-count');

function TransactionRecDep() {
    this.hash = 0; /*int*/

    this.count = 0; /*int*/
    this.error = 0; /*int*/

    this.time_sum = 0; /*long*/
    this.time_max = 0; /*int*/
    
    this.sql_count = 0; /*int*/
    this.sql_time = 0; /*long*/
    this.sql_fetch = 0; /*int*/
    this.sql_fetch_time = 0; /*long*/
    


    this.httpc_count = 0; /*int*/
    this.httpc_time = 0; /*long*/
    this.malloc_sum = 0; /*long*/
    this.cpu_sum = 0; /*long*/

  /*임시변수 서버전송 안함*/  this.profiled = false;
}

TransactionRecDep.prototype.mergeForStat = function(o){
    this.count += o.count;
    this.error += o.error;
    
    this.time_sum +=o.time_sum;
    this.time_max = Math.max(this.time_max, o.time_max);
    
    this.sql_count += o.sql_count;
    this.sql_time +=o.sql_time;
    this.sql_fetch += o.sql_fetch;
    this.sql_fetch_time +=o.sql_fetch_time;
    
    this.httpc_count += o.httpc_count;
    this.httpc_time +=o.httpc_time;
    
    this.malloc_sum +=o.malloc_sum;
    this.cpu_sum +=o.cpu_sum;
};

TransactionRecDep.prototype.merge = function(o) {
    this.count += o.count;
    this.error += o.error;
    this.time_sum +=o.time_sum;
    this.time_max = Math.max(this.time_max, o.time_max);
  
    this.sql_count += o.sql_count;
    this.sql_time +=o.sql_time;
  
    this.sql_fetch += o.sql_fetch;
    this.sql_fetch_time +=o.sql_fetch_time;
  
    this.httpc_count += o.httpc_count;
    this.httpc_time += o.httpc_time;
  
    this.malloc_sum += o.malloc_sum;
    this.cpu_sum += o.cpu_sum;

};

TransactionRecDep.prototype.setUrlHash = function(hash) {
    this.hash = hash;
    return this;
};

TransactionRecDep.prototype.getDeviation = function() {
    if (this.count === 0) {
        return 0;
    }
    var avg = this.time_suthis.divide(this.count); /*long*/
    var variation = (this.time_std - (2 * avg * this.time_sum) + (this.count * avg * avg)) / this.count;

    // NAN check..
    var ret = Math.sqrt(variation);
    return isNaN(ret) ? 0 : ret;
};


TransactionRecDep.prototype.write = function(dout) {
        dout.writeInt(this.hash);
        dout.writeByte(2);
        dout.writeDecimal(this.count);
        dout.writeDecimal(this.error);
        dout.writeDecimal(this.time_sum);
        dout.writeDecimal(this.time_max);
        
        dout.writeDecimal(this.sql_count);
        dout.writeDecimal(this.sql_time);
        dout.writeDecimal(this.sql_fetch);
        dout.writeDecimal(this.sql_fetch_time);
        
        dout.writeDecimal(this.httpc_count);
        dout.writeDecimal(this.httpc_time);
        dout.writeDecimal(this.malloc_sum);
        dout.writeDecimal(this.cpu_sum);

        dout.writeDecimal(0);
        dout.writeDecimal(0);
};
TransactionRecDep.prototype.read = function(din) {
    this.hash = din.readInt();
    var ver = din.readByte();
    this.count = din.readDecNumber();
    this.error = din.readDecNumber();
    this.time_sum = din.readDecNumber();
    this.time_max = din.readDecNumber();

    this.sql_count = din.readDecNumber();
    this.sql_time = din.readDecNumber();
    this.sql_fetch = din.readDecNumber();
    this.sql_fetch_time = din.readDecNumber();
  
    this.httpc_count = din.readDecNumber();
    this.httpc_time = din.readDecNumber();
    this.malloc_sum = din.readDecNumber();
    this.cpu_sum = din.readDecNumber();

    _drop(din);
    _drop(din);

    return this;
};

function _drop(din){
    var c = din.readDecNumber();
     if (c > 0) {
         for (i = 0; i < c; i++) {
             din.readInt();
             din.readDecNumber();
             din.readDecNumber();
             din.readDecNumber();
         }
     }
}
module.exports = TransactionRecDep;
