/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack            = require('./pack'),
    PackEnum = require('./packenum'),
    TransactionRec = require('./statservice-rec'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx');

function StatServicePack1(){
    Pack.call(this);

    this.records = null; /*byte[]*/
    this.record_count = 0; /*int*/

    this.spec = 0;
    return this;
}

StatServicePack1.prototype = new Pack();
StatServicePack1.prototype.constructor = StatServicePack1;

StatServicePack1.prototype.getPackType = function(){
    return PackEnum.STAT_SERVICE_1;
};

StatServicePack1.prototype.write = function(dout){
    Pack.prototype.write.call(this, dout);

    dout.writeBlob(this.records);
    dout.writeDecimal(this.record_count);
    
    dout.writeByte(0);
    dout.writeDecimal(this.spec);
};

StatServicePack1.prototype.read = function(din){
    Pack.prototype.read.call(this, din);
    this.records = din.readBlob();
    this.record_count = din.readDecNumber();

    var ver = din.readByte();
    this.spec = din.readDecimal();

    return this;
};

StatServicePack1.prototype.setRecords = function(size /*int*/, items /*Enumer<TransactionRec>*/) {
    var dout = new DataOutputX();
    dout.writeShort(size);

    while(items.hasMoreElements()) {
        let aa = items.nextElement();
        TransactionRec.writeRec(dout, aa);
    }

    this.records = dout.toByteArray();
    this.record_count = size;
    return this;
};

StatServicePack1.prototype.getRecords = function() {
    var items = [];
    if (this.records == null) {
        return [];
    }

    var din = new DataInputX(this.records);
    var size = din.readShort();
    for (var i = 0; i < size; i++) {
        items.push(new TransactionRec().read(din));
    }
    return items;
};

StatServicePack1.prototype.toString = function() {
    return 'StatServicePack1 '
        + Pack.prototype.toString.call(this)
        + ', records='
        + this.record_count
        + ", bytes="
        + (this.records != null ? this.records.length : 0);
};

module.exports = StatServicePack1;