/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack            = require('./pack'),
    PackEnum = require('./packenum'),
    TransactionRec = require('./statservice-rec'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx');

function StatServicePack(){
    Pack.call(this);

    this.records = null; /*byte[]*/
    this.record_count = 0; /*int*/

    return this;
}

StatServicePack.prototype = new Pack();
StatServicePack.prototype.constructor = StatServicePack;
StatServicePack.prototype.getPackType = function(){
    return PackEnum.STAT_SERVICE;
};
StatServicePack.prototype.write = function(dout){
    Pack.prototype.write.call(this, dout);
    dout.writeBlob(this.records);
    dout.writeDecimal(this.record_count);
};
StatServicePack.prototype.read = function(din){
    Pack.prototype.read.call(this, din);
    this.records = din.readBlob();
    this.record_count = din.readDecNumber();
    return this;
};
StatServicePack.prototype.setRecords = function(size /*int*/, items /*Enumer<TransactionRec>*/) {
    var dout = new DataOutputX();
    dout.writeShort(size);
    while(items.hasMoreElements()) {
        TransactionRec.writeRec(dout, items.nextElement());
    }
    this.records = dout.toByteArray();
    this.record_count = size;
    return this;
};
StatServicePack.prototype.getRecords = function() {
    var items = [];
    if (this.records == null) {
        return [];
    }

    var din = new DataInputX(this.records);
    var cnt=din.readShort();
    for (var i = 0; i < cnt; i++) {
        // items.push(new TransactionRec().read(din));
        items.push(TransactionRec.readRec(din));
    }
    return items;
};

module.exports = StatServicePack;