/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack        = require('./pack'),
    PackEnum    = require('./packenum'),
    IntIntMap   = require('../util/intint-map');

function StatRemoteIpPack(){
    Pack.call(this);
    this.iptable = new IntIntMap();
}

StatRemoteIpPack.prototype = new Pack();
StatRemoteIpPack.prototype.constructor = StatRemoteIpPack;
StatRemoteIpPack.prototype.getPackType = function () {
    return PackEnum.STAT_REMOTE_IP;
};
StatRemoteIpPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);

    dout.writeDecimal(this.iptable.size());
    var en = this.iptable.entries();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        dout.writeInt(e.getKey());
        dout.writeInt(e.getValue());
    }
};
StatRemoteIpPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    var ip, count;
    var cnt = din.readDecNumber();
    this.iptable = new IntIntMap();

    for(var i=0; i<cnt; i++) {
        ip = din.readInt();
        count = din.readInt();
        this.iptable.put(ip, count);
    }
    return this;
};

module.exports = StatRemoteIpPack;