/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var BitUtil = require('../util/bitutil'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx');

function HttpcRec(){
    this.url = 0;
    this.host = 0;
    this.port = 0;
    this.count_total = 0;
    this.count_error = 0;
    this.time_sum = 0;
    this.time_std = 0;
    this.time_min = 0;
    this.time_max = 0;
    this.service = 0;
 }
HttpcRec.prototype.merge = function (o) {
    this.count_total += o.count_total;
    this.count_error += o.count_error;
    this.time_sum += o.time_sum;
    this.time_std = o.time_std;
    this.time_max = Math.max(this.time_max, o.time_max);
    this.time_min = Math.min(this.time_min, o.time_min);
};

HttpcRec.prototype.write = function(dout){
        dout.writeInt(this.url);
        dout.writeInt(this.host);
        dout.writeInt(this.port);
        dout.writeDecimal(this.count_total);
        dout.writeDecimal(this.count_error);
        dout.writeDecimal(-1);
        dout.writeDecimal(this.time_sum);
        dout.writeDecimal(this.time_std);
        dout.writeDecimal(this.time_min);
        dout.writeDecimal(this.time_max);

        dout.writeDecimal(this.service);
};
HttpcRec.prototype.read = function(din) {
    this.url = din.readInt();
    this.host = din.readInt();
    this.port = din.readInt();
    this.count_total = din.readDecNumber();
    this.count_error = din.readDecNumber();
    var ver = din.readDecNumber();
    this.time_sum = din.readDecNumber();
    this.time_std = din.readDecNumber();
    this.time_min = din.readDecNumber();
    this.time_max = din.readDecNumber();
    if(ver>=0){
       return this;
    }
    this.service = din.readDecNumber();
    return this;
};
HttpcRec.writeRec = function(dout , m){
    dout.writeInt(m.url);
    dout.writeInt(m.host);
    dout.writeInt(m.port);
    dout.writeDecimal(m.count_total);
    dout.writeDecimal(m.count_error);
    dout.writeDecimal(-1);
    dout.writeDecimal(m.time_sum);
    dout.writeDecimal(m.time_std);
    dout.writeDecimal(m.time_min);
    dout.writeDecimal(m.time_max);

    dout.writeDecimal(m.service);
};

module.exports = HttpcRec;
