/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack = require('./pack'),
    PackEnum = require('./packenum'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx'),
    HttpcRec = require('./stathttpc-rec');

function StatHttpcPack() {
    Pack.call(this);

    this.records = null; /*byte[]*/
    this.record_count = 0; /*int*/
}

StatHttpcPack.prototype = new Pack();
StatHttpcPack.prototype.constructor = StatHttpcPack;
StatHttpcPack.prototype.getPackType = function(){
    return PackEnum.STAT_HTTPC;
};
StatHttpcPack.prototype.setRecords = function(size /*int*/, items /*Enumeration<HttpcRec>*/) {
    var dout = new DataOutputX();
    dout.writeShort(size);
    while(items.hasMoreElements()) {
        HttpcRec.writeRec(dout, items.nextElement());
    }
    /*
    for (var i = 0; i < size; i++) {
        items.nextElement().write(dout);
    }
    */
    this.records = dout.toByteArray();
    this.record_count = size;
    return this;
};

StatHttpcPack.prototype.getRecords = function() {
    var items = [];
    if (this.records == null ) {
        return null;
    }

    var din = new DataInputX(this.records);
    for (var i = 0; i < din.readShort(); i++) {
        items.push(new HttpcRec().read(din));
    }
    return items;
};
StatHttpcPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeBlob(this.records);
    dout.writeDecimal(this.record_count);
};

StatHttpcPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    this.records = din.readBlob();
    this.record_count = din.readDecNumber();
    return this;
};

module.exports = StatHttpcPack;
