/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack'),
    BitUtil = require('../util/bitutil'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx'),
    Long = require('long');

function ErrorRec() {
    this.classHash = 0;
    this.service = 0;
    this.snapSeq = Long.ZERO;
    this.msg = 0;
    this.count = 0;

    this.merge = function(rec) {
        if(rec instanceof ErrorRec) {
            this.count += rec.count;
        }
    };

    this.getKey = function () {
        return BitUtil.composite(this.classHash, this.service);
    }
}

function StatErrorPack() {
    Pack.call(this);
    this.records = null;
    this.record_count = 0;

    this.setRecords = function(size /*int*/, items /*Enumeration<ErrorRec>*/) {
        var dout = new DataOutputX();
        dout.writeShort(size);

        while(items.hasMoreElements()) {
            StatErrorPack.writeRec(dout, items.nextElement());
        }
        /*
        for (i = 0; i < size; i++) {
            StatErrorPack.writeRec(dout, items.nextElement());
        }
        */
        this.records = dout.toByteArray();
        this.record_count = size;
        return this;
    };

    this.getRecords = function() {
        var items = [];
        if (this.records == null ) {
            return null;
        }

        var din = new DataInputX(this.records);
        var i;
        for (i = 0; i < din.readShort(); i++) {
            items.push(StatErrorPack.readRec(din));
        }
        return items;
    };
}


StatErrorPack.writeRec = function(dout, m){
    if(m instanceof ErrorRec) {
        dout.writeInt(m.classHash);
        dout.writeInt(m.service);
        dout.writeLong(m.snapSeq);
        dout.writeDecimal(m.msg);
        dout.writeDecimal(m.count);
    }
};

StatErrorPack.readRec = function(din) {
    var m = new ErrorRec();
    m.classHash = din.readInt();
    m.service = din.readInt();
    m.snapSeq = din.readLong();
    m.msg = din.readDecNumber();
    m.count = din.readDecNumber();
    return m;
};

StatErrorPack.prototype = new Pack();
StatErrorPack.prototype.constructor = StatErrorPack;

StatErrorPack.prototype.getPackType = function() {
    return PackEnum.STAT_ERROR;
};

StatErrorPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeBlob(this.records);
    dout.writeDecimal(this.record_count);
};

StatErrorPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    this.records = din.readBlob();
    this.record_count = din.readDecNumber();
    return this;
};

StatErrorPack.prototype.toString = function() {
    return 'StatError '
        + Pack.prototype.toString.call(this)
        + ', records='
        + this.record_count
        + ", bytes="
        + (this.records != null ? this.records.length : 0);
};

exports.ErrorRec = ErrorRec;
exports.StatErrorPack = StatErrorPack;