/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack        = require('./pack'),
    PackEnum    = require('./packenum'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx'),
    AnyList   = require('../util/anylist');
    StringKeyLinkedMap   = require('../util/stringkey-linkedmap');

function  StatGeneralPack() {
    Pack.call(this);
    this.id = "";
    this.data = new StringKeyLinkedMap();
    this.dataBytes = null;
    this.dataBytesSize = 0;
}

StatGeneralPack.prototype = new Pack();
StatGeneralPack.prototype.constructor = StatGeneralPack;
StatGeneralPack.prototype.getPackType = function () {
    return PackEnum.STAT_GENERAL;
};
StatGeneralPack.prototype.write = function (dout) {
    Pack.prototype.write.call(this, dout);

    dout.writeText(this.id);
    if(this.dataBytes == null){
        this.dataBytes = writeTable(this.data);
        this.dataBytesSize = this.dataBytes.length;
    }
   dout.writeInt24BE(this.dataBytesSize);
   dout.write(this.dataBytes);
};
function writeTable(data) {
    var dd = new DataOutputX();
    dd.writeShort(data.size());
    var en = data.entries();
    while (en.hasMoreElements()) {
       var ent = en.nextElement();
        dd.writeText(ent.getKey());
        dd.writeByte(ent.getValue().getType()); // type
        ent.getValue().write(dd); // data
    }
    return dd.toByteArray();
}
StatGeneralPack.prototype.read = function (din) {
    Pack.prototype.read.call(this, din);
    this.id = din.readText();
    this.dataBytesSize = din.readInt24BE();
    this.dataBytes = din.read(this.dataBytesSize);
    return this;
};
function readTable( bytes, data) {
    var din = new DataInputX(bytes);
    var cnt = din.readShort();
    for (var i = 0; i < cnt; i++) {
        var key = din.readText();
        var a = new AnyList(din.readByte());
        a.read(din);
        data.put(key, a);
    }
    return cnt;
}
StatGeneralPack.prototype.unpack = function() {
    if (this.dataBytes != null) {
        readTable(this.dataBytes, this.data);
        this.dataBytes = null;
        this.dataBytesSize = 0;
    }
}

StatGeneralPack.prototype.toString = function () {
    var str = "StatGeneral ";
    str += Pack.prototype.toString.call(this);
    str += ", useragents=";
    str += this.userAgents.size();
    return str;
};
StatGeneralPack.prototype.put = function (key, data) {
    this.data.put(key, data);
};

StatGeneralPack.prototype.get = function (key) {
    this.unpack();
    return this.data.get(key);
};

StatGeneralPack.prototype.isEmpty = function () {
    return this.dataBytesSize == 0 && this.data.isEmpty();
};

module.exports = StatGeneralPack;