/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum    = require('./packenum'),
    Pack        = require('./pack'),
    DataOutputX = require('../io/data-outputx'),
    DataInputX  = require('../io/data-inputx');

function RealTimeUserPack(rType) {
    this.cadinality;
    Pack.call(this);
    this.logbits = null;
}

RealTimeUserPack.prototype = new Pack();
RealTimeUserPack.prototype.constructor = RealTimeUserPack;
RealTimeUserPack.prototype.toString = function() {
    return 'RealtimeUserPack '
        + Pack.prototype.toString.call(this)
        + ', logbits='
        + (this.logbits != null ? this.logbits.length : 0);
};
RealTimeUserPack.prototype.getPackType = function() {
    return PackEnum.REALTIME_USER_1; //<-- 버전업함 
};
RealTimeUserPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeBlob(this.logbits);
    dout.writeDecimal(this.cadinality);
};
RealTimeUserPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    this.logbits = din.readBlob();
    this.cadinality= din.readDecNumber();
    return this;
};

module.exports = RealTimeUserPack;