/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack'),
    TxRecord = require('../service/tx-record'),
    Step = require('../step/step');

function ProfilePack() {
    Pack.call(this);
    this.service = null;
    this.steps = null;
}

ProfilePack.prototype = new Pack();
ProfilePack.prototype.constructor = ProfilePack;
ProfilePack.prototype.toString = function() {
    var text = 'Profile '
        + Pack.prototype.toString.call(this)
        + ', step_bytes='
        + ((this.steps != null) ? this.steps.length : 0);
    if (this.service != null) {
        text += " time=" + this.service.endTime + ", active=" + this.service.active;
    }
    return text;
};
ProfilePack.prototype.getPackType = function() {
    return PackEnum.PROFILE;
};
ProfilePack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    this.service.write(dout);
    dout.writeBlob(this.steps);
};
ProfilePack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    this.service = new TxRecord().read(din);
    this.steps = din.readBlob();
    return this;
};
ProfilePack.prototype.setProfile = function(steps) {
    this.steps = Step.toBytes(steps);
    return this;
};

module.exports = ProfilePack;