/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long = require('long');
var DateUtil = require('./../util/dateutil');

function Pack() {
    this.pcode = 0; /*long*/
    this.oid = 0; /*int*/
    this.okind = 0;
    this.onode = 0;
    this.time = DateUtil.currentTime(); /*long*/
};

Pack.prototype.getPackType = function() {
    return 0;
};
Pack.prototype.write = function(dout) {
    if(this.okind===0 && this.onode ===0){
        dout.writeDecimal(this.pcode);
        dout.writeInt32BE(this.oid);
        dout.writeLong(this.time);
    }else{
        dout.writeByte(9);
        dout.writeDecimal(this.pcode);
        dout.writeInt(this.oid);
        dout.writeInt(this.okind);
        dout.writeInt(this.onode);
        dout.writeLong(this.time);
    }
};
Pack.prototype.read = function(din) {
    var ver = din.readByte();
    if(ver<=8) {
        this.pcode = din.readDecNumberLen(ver);
        this.oid = din.readInt();
        this.time = din.readLong();
    }else{
        this.pcode=din.readDecimal();
		this.oid = din.readInt();
		this.okind = din.readInt();
		this.onode = din.readInt();
		this.time = din.readLong();
    }
};

module.exports = Pack;