/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack = require('./pack'),
    PackEnum = require('./packenum'),
    Logger = require('../logger');

function HitMapPack1() {
    Pack.call(this);
    this.hit = new Array(HitMapPack1.LENGTH);
    this.error = new Array(HitMapPack1.LENGTH);

    this.hit.fill(0);
    this.error.fill(0);
}

HitMapPack1.LENGTH = 120;
HitMapPack1.prototype = new Pack();
HitMapPack1.prototype.constructor = HitMapPack1;
HitMapPack1.prototype.getPackType = function () {
    return PackEnum.HITMAP_1;
};
HitMapPack1.prototype.write = function (dout) {
    Pack.prototype.write.call(this, dout);
    // dout.writeByte(1);
    // for(var i=0; i<HitMapPack1.LENGTH; i++) {
    //     dout.writeShort(this.hit[i]);
    //     dout.writeShort(this.error[i]);
    // }
    dout.writeByte(3);// version
	writeArr(dout, this.hit);
	writeArr(dout, this.error);
};
HitMapPack1.prototype.read = function (din) {
    Pack.prototype.read.call(this, din);
    var ver = din.readByte();

    if(ver === 1) {
        for(var i=0; i<HitMapPack1.LENGTH; i++) {
            this.hit[i] = din.readShort() & 0xffff;
            this.error[i] = din.readShort() & 0xffff;
        }
    }
    if(ver === 3){
        readArr(din, this.hit);
		readArr(din, this.error);
    }
    return this;
};

function writeArr( dout,  arr) {
    try{
        if (arr == null) {
            dout.writeByte(0);
        } else {
            var len = HitMapPack1.LENGTH - 1;
            for (; len >= 0; len--) {
                if (arr[len] != 0)
                    break;
            }
            len = len + 1;
            dout.writeByte(len);
            for (var i = 0; i < len; i++) {
                dout.writeUInt16BE(arr[i]);
            }
        }
    }catch (e) {
        Logger.printError('WHATAP-088', 'Hit-map pack - write error', e, false);
    }
}

function readArr( din, arr) {
    var len = din.readByte() & 0xff;
    for (var i = 0; i < len; i++) {
        arr[i] = din.readShort() & 0xffff;
    }
}
HitMapPack1.prototype.copy = function () {
    var newOne = new HitMapPack1();
    newOne.pcode = this.pcode;
    newOne.oid = this.oid;
    newOne.time = this.time;

    newOne.hit = this.hit.slice();
    newOne.error = this.error.slice();
    return newOne;
};
HitMapPack1.prototype.merge = function (p) {
    for(var i=0; i<this.LENGTH; i++) {
        this.hit[i] += p.hit[i];
        this.error[i] += p.error[i];
    }
};
HitMapPack1.prototype.add = function (time, isError) {
    var idx = HitMapPack1.index(time);
    this.hit[idx]++;
    if(isError) {
        this.error[idx]++;
    }
};
HitMapPack1.prototype.toString = function() {
    return 'HitMap1 ' + Pack.prototype.toString.call(this) + ', hit=' + this.hit.length + ", error=" + this.error.length;
};

HitMapPack1.index = function (time) {
    var x = parseInt(time / 10000);
    switch (x) {
        case 0:
            if (time < 5000)
                return parseInt(time / 125);
            else
                return 40 + parseInt((time - 5000) / 250);
        case 1:
            return 60 + parseInt((time - 10000) / 500);
        case 2:
        case 3:
            return 80 + parseInt((time - 20000) / 1000);
        case 4:
        case 5:
        case 6:
        case 7:
            return 100 + parseInt((time - 40000) / 2000);
        default:
            return 119;
    }
};
HitMapPack1.time = function(index) {
    var _time = 0;
    if (index < 40)
        return index * 125;
    _time = 5000;
    if (index < 60)
        return _time + (index - 40) * 250;
    _time = 10000;
    if (index < 80)
        return _time + (index - 60) * 500;

    _time = 20000;
    if (index < 100)
        return _time + (index - 80) * 1000;

    _time = 40000;
    if (index < 120)
        return _time + (index - 100) * 2000;
    return 80000;
};


module.exports = HitMapPack1;