/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack');

function HitMapPack() {
    this.hitCount = 0;
    this.errorCount = 0;
    this.hit = [];
    this.error = [];
    this.time90pct = 0;
};

HitMapPack.prototype.getPackType = function() {
    return PackEnum.HITMAP;
};
HitMapPack.prototype.write = function(dout) {

    Pack.prototype.write.call(this, dout);
    dout.writeDecimal(this.hitCount);
    dout.writeDecimal(this.errorCount);
    dout.writeDecimal(this.time90pct);
    this.writeIntArray(dout, this.hit);
    this.writeIntArray(dout, this.error);
};
HitMapPack.prototype.read = function(din) {

    Pack.prototype.read.call(this, din);
    this.hitCount = din.readDecLong();
    this.errorCount = din.readDecLong();
    this.time90pct = din.readDecNumber();
    this.readIntArray(din, this.hit);
    this.readIntArray(din, this.error);

    return this;
};
HitMapPack.prototype.writeIntArray = function(dout, v){

    if(v == null) {
        dout.writeByte(0);
    } else {
        dout.writeByte(v.length);
        for(var val in v) {
            dout.writeDecimal(val);
        }
    }
};
HitMapPack.prototype.readIntArray = function(din, map) {
    var len = din.readByte();
    for(var i=0; i<len; i++) {
        if(i < map.length) {
            map[i] = din.readDecNumber();
        }
    }
};

exports.Instance = HitMapPack;
exports.PCT_BOX = 50;
exports.HIT_MAP = 51;