/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack');

function EventPack() {
    Pack.call(this);
    this.level = 0;
    this.title = '';
    this.message = '';
    this.attr = {};
}
EventPack.prototype = new Pack();
EventPack.prototype.constructor = EventPack;
EventPack.prototype.getPackType = function() {
    return PackEnum.EVENT;
};
EventPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);

    dout.writeByte(this.level);
    dout.writeText(this.title);
    dout.writeText(this.message);
    dout.writeByte(Object.keys(this.attr).length);

    for(var key in this.attr) {
        dout.writeText(key);
        dout.writeText(this.attr[key]);
    }
};
EventPack.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);

    this.level = din.readByte();
    this.title = din.readText();
    this.message = din.readText();

    var keySize = din.readByte(),
        key, value;

    for(var i=0; i<keySize; i++) {
        key = din.readText();
        value = din.readText();
        this.attr[key] = value;
    }

    return this;
};

module.exports = EventPack;