/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var PackEnum = require('./packenum'),
    Pack = require('./pack'),
    Step = require('../step/step'),
    DataOutputX = require('../io/data-outputx'),
    Long = require('long');

function ErrorSnapPack1() {
    Pack.call(this);
    this.seq = Long.ZERO;
    this.profile = null;
    this.stack = null;
    this.append_type = 0;
    this.append_hash = 0;
    this.setProfile = function(steps){
        this.profile = Step.toBytes(steps);
        return this;
    };
    this.setStack = function(callstacks) {
        this.stack = new DataOutputX().writeIntArray(callstacks).toByteArray();
        return this;
    };
    this.getProfile = function() {
        return Step.toObjects(this.stack);
    };
    this.getStack = function() {
        if( this.stack == null || this.stack.length === 0 ) {
            return null;
        }
        return this.stack;
    }
}

ErrorSnapPack1.prototype = new Pack();
ErrorSnapPack1.prototype.constructor = ErrorSnapPack1;
ErrorSnapPack1.prototype.toString = function() {
    return "ErrorSnap " + Pack.prototype.toString.call(this)
        + ", profile_bytes="
        + ((this.profile != null) ? this.profile.length : 0)
        + " stack_bytes="
        + ((this.stack != null) ? this.stack.length : 0);
};
ErrorSnapPack1.prototype.getPackType = function () {
    return PackEnum.ERROR_SNAP_1;
};
ErrorSnapPack1.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeLong(this.seq);
    dout.writeBlob(this.profile);
    dout.writeBlob(this.stack);
    dout.writeByte(this.append_type);
    dout.writeDecimal(this.append_hash);
};
ErrorSnapPack1.prototype.read = function(din) {
    Pack.prototype.read.call(this, din);
    this.seq = din.readLong();
    this.profile = din.readBlob();
    this.stack = din.readBlob();
    this.append_type = din.readByte();
    this.append_hash = din.readDecNumber();
    return this;
};

module.exports = ErrorSnapPack1;