/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Pack = require('./pack'),
    PackEnum = require('./packenum'),
    Long = require('long');

function ActiveStackPack() {
    Pack.call(this);

    this.seq = Long.ZERO;
    this.txid = Long.ZERO;
    this.service = 0;
    this.elapsed = 0;

    this.callstack = [];
    this.callstack_hash = 0;
}

ActiveStackPack.prototype = new Pack();
ActiveStackPack.prototype.constructor = ActiveStackPack;
ActiveStackPack.prototype.getPackType = function () {
    return PackEnum.ACTIVESTACK_1;
};
ActiveStackPack.prototype.write = function(dout) {
    Pack.prototype.write.call(this, dout);
    dout.writeByte(1);
    dout.writeLong(this.seq);
    dout.writeLong(this.txid);
    dout.writeDecimal(this.service);
    dout.writeDecimal(this.callstack_hash);
    dout.writeIntArray(this.callstack);
    dout.writeDecimal(this.elapsed);
};
ActiveStackPack.prototype.read = function(din) {

    Pack.prototype.read.call(this, din);
    var ver= din.readByte();
    this.seq = din.readLong();
    this.txid = din.readLong();
    this.service = din.readDecNumber();

    this.callstack_hash = din.readDecNumber();
    this.callstack = din.readIntArray();
    if(ver>0){
        this.elapsed = din.readDecNumber();
    }
    return this;
};


module.exports = ActiveStackPack;