/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var TraceContextManager = require('../trace/trace-context-manager'),
    MethodStepX            = require('../step/method-stepx'),
    DBCStep             = require('../step/dbc-step'),
    ResultSetStep       = require('../step/resultset-step'),
    DataTextAgent       = require('../data/datatext-agent'),
    StatSql             = require('../stat/stat-sql'),
    MeterSql            = require('../counter/meter/meter-sql'),
    conf                = require('../conf/configure'),
    IntKeyMap           = require('../util/intkey-map'),
    EscapeLiteralSQL    = require('../util/escape-literal-sql'),
    HashUtil            = require('../util/hashutil'),
    StatError           = require('../stat/stat-error'),
    TextTypes           = require('../lang/text-types'),
    ParamSecurity       = require('../util/paramsecurity'),
    Logger              = require('../logger'),
    Buffer              = require('buffer').Buffer;

var ThriftObserver = function (agent) {
    this.agent = agent;
    this.packages = ['thrift'];
};


ThriftObserver.prototype.inject = function (mod, moduleName) {
    if (mod.__whatap_observe__) {
        return;
    }
    mod.__whatap_observe__ = true;
    Logger.initPrint("ThriftObserver");
    var self = this;
    var aop = self.agent.aop;

    if (conf.trx_profile_thrift_enabled == false) {
        return;
    }

    aop.both(mod, 'createConnection',
        createConnectionBeforeHook,
        createConnectionAfterHook);

    aop.both(mod, 'createSSLConnection',
        createConnectionBeforeHook,
        createConnectionAfterHook);


    function createConnectionBeforeHook(obj, args, lctx) {
        var ctx = lctx.context;
        if(ctx == null || ctx.db_opening) { return; }

        ctx.thrift_opeing = true;

        var dbc_step = new DBCStep();
        dbc_step.start_time = ctx.getElapsedTime();
        lctx.step = dbc_step;

    }


    function createConnectionAfterHook(obj, args, ret, lctx){

        var dbc, dbc_hash;
        if(args.length > 1) {
            var host = args[0];
            var port = args[1];
            //Open [DatabaseName] connection 메세지 보여줄때 필요함.
            dbc = 'thrift://';
            dbc += host || '';
            dbc += ':';
            dbc += port || '';
            dbc_hash = HashUtil.hashFromString(dbc);
            DataTextAgent.DBC.add(dbc_hash, dbc);
            DataTextAgent.METHOD.add(dbc_hash, dbc);
            DataTextAgent.ERROR.add(dbc_hash, dbc);

            ret.dbc_hash = dbc_hash;
            ret.dbc_string = dbc;
        }

        var ctx = lctx.context,
            step = lctx.step;

        // secureConnect, connect, error, close, timeout

        if (ctx == null || step == null) { return; }

        TraceContextManager.resume(ctx);
        step.hash = dbc_hash;

        ret.on('connect', connectComplete);
        ret.on('secureConnect', connectComplete);

        function connectComplete(obj, args){
            // var ctx = TraceContextManager.getCurrentContext();
            // var step = ctx.step;

            if (ctx == null || step == null) { return; }

            ctx.profile.push(step);
        }

        aop.before(ret, 'error', function (obj, args) {

        });
    }

    aop.both(mod, 'createClient',
        function(obj, args, lctx) {

        },
        function(obj, args, ret, lctx){

            var proto = ret.__proto__;

            var funcKeys = Object.keys(proto).map(function(key){
                if(proto[key] && proto[key].constructor == Function) {
                    return key;
                }
            }).filter(function(key){ return key !== undefined })

            var dbc_hash = undefined;
            var dbc_string = undefined;
            if(args.length > 1){
                var conn = args[1];
                if(conn.dbc_hash){
                    dbc_hash = conn.dbc_hash;
                    dbc_string = conn.dbc_string;
                }
            }

            if(proto.__whatap_hook__ == true) return;

            funcKeys.forEach(function(key){
                var method_string = dbc_string + '/' + key;
                var method_hash = HashUtil.hashFromString(method_string);
                // DataTextAgent.DBC.add(dbc_hash, dbc);
                DataTextAgent.METHOD.add(method_hash, method_string);

                proto.__whatap_hook__ = true;
                aop.both(proto, key , startThriftFunc(method_hash, self.agent) ,
                    endThriftFunc
                )
            })
        });

    var startThriftFunc = function (method_hash, agent) {

        return function (obj, args) {
            var ctx = TraceContextManager.getCurrentContext();

            if (ctx == null || args[0] == null) { return; }
            // if(args[0].sql == null && typeof args[0] != 'string') { return; }

            var method_step = new MethodStepX();
            method_step.start_time = ctx.getElapsedTime();
            method_step.hash = method_hash;

            ctx.profile.push(method_step);
            // ctx.sql_count++;
        }
    }

    var endThriftFunc = function (obj, args, ret, lctx) {

        if(args != undefined && args.length > 0 && args[args.length-1] !== undefined && args[args.length-1].constructor === Function){
            agent.aop.functionHook(args, -1, endHook);
        }else{
            endHook();
        }
    }

    function endHook(obj, args){
        var ctx = TraceContextManager.getCurrentContext();
        if(ctx == null ) { return; }

        TraceContextManager.resume(ctx._id);

        var laststep = ctx.profile.getLastSteps(1);
        if(laststep == null || laststep.length == 0) { return; }

        var step = laststep[0];
        step.elapsed = ctx.getElapsedTime() - step.start_time;
        ctx.sql_time += sql_step.elapsed;
    }

    aop.after(mod, ['createPool', 'createPoolCluster'], function (obj, args, ret) {

    });

}

exports.ThriftObserver = ThriftObserver;