/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

 var TraceContextManager = require('../trace/trace-context-manager'),
 conf                = require('../conf/configure'),
 DataTextAgent       = require('../data/datatext-agent'),
 DataProfileAgent    = require('../data/dataprofile-agent'),
 EventLevel          = require('../data/event-level'),
 TxRecord          = require('../service/tx-record'),
 ProfilePack         = require('../pack/profile-pack'),
 SecurityMaster      = require('../net/security-master'),
 HashUtil            = require('../util/hashutil'),
 DateUtil            = require('../util/dateutil'),
 ResourceProfile     = require('../util/resourceprofile'),
 MessageStep         = require('../step/message-step'),
 Logger              = require('../logger');

var ScheduleObserver = function(agent){
 this.agent = agent;
 this.packages = ['node-schedule'];
};

ScheduleObserver.prototype.inject = function (mod, moduleName) {
    if(mod.__whatap_observe__) { return; }
    mod.__whatap_observe__ = true;
    Logger.initPrint("ScheduleObserver");
    var self = this;
    var aop = self.agent.aop;

    aop.after(mod, 'scheduleJob',
    function (obj, args, ret) {
        var orig = ret.job;
        if(!orig) return;
        ret.job = async () => {
            var ctx = null;
            if(conf['trace_node_schedule_enabled']) {
                ctx = TraceContextManager.startTrace('ScheduleJob');
            }
            var result = null;
            try {
                result = await orig.apply(this, arguments);   
            } catch(err) {
                Logger.printError('WHATAP-607', 'End batch error..', err, false);
            }
            if(conf['trace_node_schedule_enabled'] && ctx != null) {
                try {
                    var step = new MessageStep();
                    step.msg = 'Node ScheduleJob finished!!!!!'
                    step.hash =  HashUtil.hashFromString(step.msg);;
                    step.start_time = ctx.getElapsedTime();
                    step.desc = '';
                    DataTextAgent.MESSAGE.add(step.hash, step.msg);
                    ctx.profile.add(step);
                    TraceContextManager.endTrace(ctx);
                    if(ctx != null) ctx = null;
                } catch(err) {}
             }
            return result;
        };
    }
);
};

exports.ScheduleObserver = ScheduleObserver;