var TraceContextManager = require('../trace/trace-context-manager'),
    DataTextAgent = require('../data/datatext-agent'),
    SqlStepX = require('../step/sql-stepx'),
    DBCStep = require('../step/dbc-step'),
    TextTypes = require('../lang/text-types'),
    HashUtil = require('../util/hashutil'),
    Long = require('long'),
    Logger = require('../logger');
const shimmer = require('../core/shimmer');

var RedisObserver = function (agent) {
    this.agent = agent;
    this.aop = agent.aop;
    this.packages = ['redis', 'ioredis'];
};

RedisObserver.prototype.inject = function (mod, modName) {

    if (mod.__whatap_observe__) {
        return;
    }
    mod.__whatap_observe__ = true;
    Logger.initPrint("RedisObserver");
    var self = this;

    var dbc_hash = 0;
    var dbc;
    var dbc_time;
    self.aop.both(mod, 'createClient',
        function (obj, args, lctx) {
            if (dbc_hash === 0) {
                if (args.length > 0) {
                    var info = (args[0] || {});
                    dbc = 'redis://';
                    dbc += info.host || '';
                    dbc += ':';
                    dbc += info.port || '';
                    dbc_hash = HashUtil.hashFromString(dbc);
                }
            }
        },
        function (obj, args, ret, lctx) {
            var selectCommand = new Set(['get', 'hGet', 'hmGet']);
            var insertCommand = new Set(['set', 'hSet', 'hset', 'hmSet', 'hmset', 'zAdd', 'zadd', 'lSet', 'lset']);
            var updateCommand = new Set(['set', 'lSet', 'lset', 'hSet', 'hset', 'zAdd', 'zadd']);
            var deleteCommand = new Set(['del', 'lRem', 'sRem', 'srem', 'hDel', 'hdel', 'zRem', 'zrem']);
            var commands = new Set([...selectCommand, ...insertCommand, ...updateCommand, ...deleteCommand]);
            commands.forEach(function (command) {
                self.aop.after(ret, command,
                    function (obj, args, ret, lctx) {
                        var ctx = TraceContextManager.getCurrentContext();
                        if (ctx == null) {
                            return;
                        }

                        var dbc_step = new DBCStep();
                        dbc_step.hash = dbc_hash;
                        dbc_step.start_time = dbc_time;
                        dbc_step.elapsed = ctx.getElapsedTime() - dbc_step.start_time;
                        ctx.profile.push(dbc_step);

                        var sql_step;
                        try {
                            sql_step = new SqlStepX();
                            const key = args[0];
                            const values = [];
                            for (let i = 1; i < args.length; i++)
                                values.push(args[i]);

                            var sql = 'Redis ' + command + ': ' + JSON.stringify([key]);
                            // if (values.length > 0)
                            //     sql += ' ' + JSON.stringify(values);
                            sql_step.hash = HashUtil.hashFromString(sql);
                            sql_step.start_time = ctx.getElapsedTime();
                            //sql_step.crud = 'I'.charCodeAt(0);
                            // DataTextAgent.SQL.add(sql_step.hash, sql);
                            ctx.profile.push(sql_step);
                        } catch (e) {
                            Logger.printError("WHATAP-605", "Redis CRUD error", e, false);
                            sql_step = null;
                        }
                    })
            })

            var dbc_step = lctx.step,
                ctx = lctx.context;

            if (ctx == null) {
                return;
            }

            var client = ret;
            var method = client.internal_send_command
                ? "internal_send_command"
                : "send_command";

            var address = 'redis://'
            address += (client.address || (client.host + ':' + client.port)) || '';
            dbc_step.elapsed = ctx.getElapsedTime() - dbc_step.start_time;
            dbc_step.hash = HashUtil.hashFromString(address);
            DataTextAgent.DBC.add(dbc_step.hash, address);

            ctx.profile.push(dbc_step);

            self.aop.before(client, method, function (obj, args) {
                var command, params;
                try {
                    if (typeof (args[0]) === 'string') {
                        command = args[0];
                        params = args[1];
                    } else {
                        command = args[0].command;
                        params = args[0].args;
                    }
                } catch (e) {
                    command = '';
                    params = '';
                }

                var sql = command + ' ' + params;
                var sql_step = new SqlStepX();
                sql_step.start_time = ctx.getElapsedTime();
                sql_step.hash = HashUtil.hashFromString(sql);
                sql_step.dbc = dbc_step.hash;
                //sql_step.crud = 'S'.charCodeAt(0);
                ctx.profile.push(sql_step);

                DataTextAgent.SQL.add(sql_step.hash, sql);

                ctx.footprint('Redis Command Start');
                var hasCallback = self.aop.functionHook(args[1], -1, function (obj, args) {

                    TraceContextManager.resume(ctx._id);
                    if (args[0]) {
                        //error
                        sql_step.error = StatError.addError(
                            'redis',
                            (args[0].message || 'redis error'),
                            ctx.service_hash,
                            TextTypes.SQL,
                            sql_step.hash);
                        if (ctx.error.isZero()) {
                            ctx.error = sql_step.error;
                        }
                    }
                    sql_step.elapsed = sql_step.start_time - ctx.getElapsedTime();

                    ctx.footprint('Redis Command Done');

                });

                // if(hasCallback === false) {
                //    ctx.footprint('Redis Command Done');
                // }
            });
        });

    var ioredis_dbc_hash = 0;
    var ioredis_dbc;
    self.aop.both(mod.prototype, 'sendCommand', function (obj, args, lctx) {
        if (ioredis_dbc_hash === 0) {
            if (obj && Object.keys(obj.options).length > 0) {
                var info = obj.options
                ioredis_dbc = 'redis://';
                ioredis_dbc += info.host || '';
                ioredis_dbc += ':';
                ioredis_dbc += info.port || '';
                ioredis_dbc_hash = HashUtil.hashFromString(ioredis_dbc);
            }
        }
    }, function (obj, args, ret, lctx) {
        var ctx = lctx.context;
        if (!ctx) {
            return;
        }

        var selectCommand = new Set(['get', 'hget', 'hmget', 'zrange', 'smembers', 'lrange']);
        var insertCommand = new Set(['set', 'hset', 'hmset', 'zadd', 'lset', 'sadd', 'lpush', 'rpush', 'evalsha']);
        var updateCommand = new Set(['set', 'lset', 'hset', 'zadd']);
        var deleteCommand = new Set(['del', 'lrem', 'srem', 'hdel', 'zrem']);
        var commands = new Set([...selectCommand, ...insertCommand, ...updateCommand, ...deleteCommand]);

        if(!args[0] || (args[0] && !args[0].name)){
            return;
        }
        var command = args[0].name;
        if(commands.has(command.toLowerCase())){
            // var ctx = TraceContextManager.getCurrentContext();
            // if (ctx == null) {
            //     return;
            // }

            var dbc_step = new DBCStep();
            dbc_step.hash = ioredis_dbc_hash;
            dbc_step.start_time = ctx.getElapsedTime();
            DataTextAgent.DBC.add(ioredis_dbc_hash, ioredis_dbc);
            ctx.profile.push(dbc_step);

            var sql_step;
            var args = args[0].args;
            try {
                sql_step = new SqlStepX();
                let key = args[0];
                if(typeof key === 'string')
                    key = [key];

                var sql = 'Redis ' + command + ': ' + JSON.stringify(key);
                sql_step.hash = HashUtil.hashFromString(sql);
                sql_step.start_time = ctx.getElapsedTime();
                DataTextAgent.SQL.add(sql_step.hash, sql);
                ctx.profile.push(sql_step);
            } catch (e) {
                Logger.printError("WHATAP-605", "Redis CRUD error", e, false);
                sql_step = null;
            }
        }
    })
};

exports.RedisObserver = RedisObserver;