/**
 * Created by yunhoi on 12/06/2017.
 */

var TraceContextManager = require('../trace/trace-context-manager'),
Logger              = require('../logger');

var PromiseObserver = function (agent) {
    this.agent = agent;
    this.packages = ['promise', 'bluebird'];
};

PromiseObserver.prototype.inject = function (mod, moduleName) {

    var self = this;
    var aop = self.agent.aop;

    if(mod.__whatap_observe__) {return;}
    mod.__whatap_observe__ = true;
    Logger.initPrint("PromiseObserver");
    aop.both(mod.prototype, 'then'
        , function (obj, args, lctx) {
            var ctx = TraceContextManager.getCurrentContext();
            aop.functionHook(args, -1, function (obj, args) {
                TraceContextManager.resume(ctx);
            })
        });

};

exports.PromiseObserver = PromiseObserver;
