/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var TraceContextManager = require('../trace/trace-context-manager'),
    SocketStep           = require('../step/socket-step'),
    conf                = require('../conf/configure'),
    IPUtil              = require('../util/iputil'),
    Logger              = require('../logger');

var trace_background_socket_enabled = conf.getProperty('trace_background_socket_enabled', false);
conf.on('trace_background_socket_enabled', function (newProps) {
    trace_background_socket_enabled = newProps;
})

var NetObserver = function(agent){
    this.agent = agent;
    this.packages = ['net'];
};

NetObserver.prototype.inject = function (mod, moduleName) {
    if(mod.__whatap_observe__) { return; }
    mod.__whatap_observe__ = true;
    Logger.initPrint("NetObserver");
    if ( !trace_background_socket_enabled ) { return; }

    var self = this;
    var aop = self.agent.aop;

    aop.both(mod.Socket.prototype, ['connect'],
        function (obj, args, lctx) {
            var ctx = lctx.context;
            if(!ctx || !trace_background_socket_enabled){
                return;
            }
            var info, host, port;
            if(args.length > 0){
                info = args[0];
                host = info.host;
                port = info.port;
            }
            if(port == undefined){
                lctx.step = null;
                return;
            }
            ctx.socket_connecting=true;

            ctx.footprint('Socket Connecting: ' + host+':'+port);

            var step = new SocketStep();
            step.start_time = ctx.getElapsedTime();
            step.ipaddr = Buffer.from(IPUtil.stringToBytes(host));
            step.port = port;
            // obj.on('lookup', function(err, ip, addressType){
            //     if(step != null) {
            //         step.ipaddr = new Buffer(IPUtil.stringToBytes(ip));
            //     }
            // });
            ctx.profile.push(step);
            lctx.step = step;
        },
        function (obj, args, ret, lctx) {
            var ctx = lctx.context;
            var step = lctx.step;
            if(!ctx || !step || !trace_background_socket_enabled){
                return;
            }
            ctx.socket_connecting=false;
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.footprint('Socket Connecting Done');
        }
    );
};

exports.NetObserver = NetObserver;