/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var TraceContextManager = require('../trace/trace-context-manager'),
    DataTextAgent       = require('../data/datatext-agent'),
    ParsedSql           = require('../trace/parsed-sql'),
    SqlStepX            = require('../step/sql-stepx'),
    DBCStep             = require('../step/dbc-step'),
    ResultSetStep       = require('../step/resultset-step'),
    HashUtil            = require('../util/hashutil'),
    IntKeyMap           = require('../util/intkey-map'),
    StatSql             = require('../stat/stat-sql'),
    StatError           = require('../stat/stat-error'),
    MeterSql            = require('../counter/meter/meter-sql'),
    EscapeLiteralSQL    = require('../util/escape-literal-sql'),
    TextTypes           = require('../lang/text-types'),
    Long                = require('long'),
    conf                = require('../conf/configure'),
    Logger              = require('../logger'),
    TraceSQL = require('../trace/trace-sql')
const DateUtil = require('../util/dateutil');
const MessageStep = require("../step/message-step");
// const ResourceProfile = require("../util/resourceprofile");

var MssqlObserver = function (agent) {
    this.agent = agent;
    this.aop = agent.aop;
    this.packages = ['mssql'];
};
var dbc_hash=0;
MssqlObserver.prototype.inject = function (mod, modName) {

    if(mod.__whatap_observe__) {return;}
    mod.__whatap_observe__ = true;

    Logger.initPrint("MssqlObserver");

    var self = this;

    var requestCommand = ['_bulk', '_query', '_execute'];

    requestCommand.forEach(function (command) {
        self.aop.both(mod.Request.prototype, command,
            function (obj, args) {

                var ctx = TraceContextManager.getCurrentContext();
                if(ctx == null) { return; }

                var sql_step = new SqlStepX();
                var sql = (typeof args[0] === 'string') ? args[0] : JSON.stringify(args[0]),
                    psql = null;


                if(dbc_hash===0){
                    if(obj.parent && obj.parent.config) {
                        var config = obj.parent.config,
                            dbc = 'mssql://';
                        try {
                            dbc += (config.server || '');
                            dbc += ':';
                            dbc += (config.port || '');
                            dbc += '/';
                            dbc += (config.database || '');
                            dbc_hash = HashUtil.hashFromString(dbc);
                            DataTextAgent.DBC.add(dbc_hash, dbc);
                            DataTextAgent.METHOD.add(dbc_hash, dbc);
                            DataTextAgent.ERROR.add(dbc_hash, dbc)
                        } catch(e) {
                        }
                    }
                }
                var dbc_step = new DBCStep();
                dbc_step.hash = dbc_hash;
                dbc_step.start_time = ctx.getElapsedTime();
                ctx.profile.push(dbc_step);

                sql_step.dbc = dbc_hash;

                try {
                    psql = escapeLiteral(sql);
                } catch(e) {
                    Logger.printError("WHATAP-192", "MssqlObserver escapeliteral error", e);
                }

                if(psql != null) {
                    DataTextAgent.SQL.add(sql_step.hash, sql);
                    // = psql.type.charCodeAt(0);
                    sql_step.hash = psql.sql;
                }
                sql_step.start_time = ctx.getElapsedTime();
                ctx.profile.push(sql_step);
                self.aop.functionHook(args, -1, function (obj, args) {
                    TraceContextManager.resume(ctx);
                    if(args[0] != null) {
                        if (conf.trace_sql_error_stack && conf.trace_sql_error_depth) {
                            var traceDepth = conf.trace_sql_error_depth;

                            var errorStack = args[0].stack.split("\n");
                            if (errorStack.length > traceDepth) {
                                errorStack = errorStack.slice(0, traceDepth + 1);
                            }
                            ctx.error_message = errorStack.join("\n");
                            sql_step.error = ctx.error = StatError.addError('mssql-' + args[0].code, args[0].message, ctx.service_hash, TextTypes.SQL, null);
                        }
                        if(conf._is_trace_ignore_err_cls_contains === true && args[0].code.indexOf(conf.trace_ignore_err_cls_contains) < 0){
                            sql_step.error = StatError.addError( 'mssql-'+args[0].code, args[0].message|| 'mssql error', ctx.service_hash,  TextTypes.SQL, sql_step.hash); /*long*/
                            if (ctx.error.isZero()) { ctx.error = sql_step.error; }
                        } else if(conf._is_trace_ignore_err_msg_contains === true && args[0].message.indexOf(conf.trace_ignore_err_msg_contains) < 0){
                            sql_step.error = StatError.addError( 'mssql-'+args[0].code, args[0].message|| 'mssql error', ctx.service_hash,  TextTypes.SQL, sql_step.hash); /*long*/
                            if (ctx.error.isZero()) { ctx.error = sql_step.error; }
                        } else if(conf._is_trace_ignore_err_cls_contains === false && conf._is_trace_ignore_err_msg_contains === false) {
                            sql_step.error = StatError.addError( 'mssql-'+args[0].code, args[0].message|| 'mssql error', ctx.service_hash,  TextTypes.SQL, sql_step.hash); /*long*/
                            if (ctx.error.isZero()) { ctx.error = sql_step.error; }
                        }
                    }

                    sql_step.elapsed = ctx.getElapsedTime() - sql_step.start_time;
                    TraceSQL.isSlowSQL(ctx);

                    MeterSql.add(dbc_hash, sql_step.elapsed, args[0] != null);
                    StatSql.addSqlTime(ctx.service_hash, sql_step.dbc,
                        sql_step.hash, sql_step.elapsed, args[0] != null, 0);

                    if(psql && psql.type == 'S') {
                        var result_step = new ResultSetStep();
                        result_step.dbc = sql_step.dbc;
                        result_step.sqlhash =  sql_step.hash;
                        try {
                            result_step.fetch = args[1][0].length;
                            ctx.rs_count = ctx.rs_count ? ctx.rs_count + args[1][0].length : args[1][0].length;
                        } catch(e) {
                        }
                        ctx.profile.push(result_step);

                        MeterSql.addFetch(dbc_hash, result_step.fetch, 0);
                        StatSql.addFetch(dbc_hash, result_step.sqlhash, result_step.fetch, 0);

                        TraceSQL.isTooManyRecords(sql_step, result_step.fetch, ctx);
                    } else if(psql && psql.type == 'U') {

                    }
                });
            }, function (obj, args, ret, lctx) {
            });
    });
    var conn_dbc_hash=0;
    self.aop.both(mod, 'connect',
        function (obj, args, lctx) {

            var ctx = TraceContextManager.getCurrentContext();
            if(ctx == null) { return; }
            lctx.context = ctx;

            var conn = '';
            if(args[0]) { //좀더 로직 개선 필요...
                conn += args[0]['server'] || '';
                conn += args[0]['database'] || '';
            }
            if(conn.length === 0) { return; }
            if(conn_dbc_hash==0){ //한번만 전송되게 함.
                conn = 'mssql://' + conn;
                conn_dbc_hash = HashUtil.hashFromString(conn);
                DataTextAgent.DBC.add(conn_dbc_hash, conn);
                DataTextAgent.METHOD.add(conn_dbc_hash, dbc);
                DataTextAgent.ERROR.add(conn_dbc_hash, dbc)
            }

            var dbc_step = new DBCStep();
            dbc_step.hash = conn_dbc_hash;
            dbc_step.start_time = ctx.getElapsedTime();

            lctx.step = dbc_step;
        },
        function (obj, args, ret, lctx) {
            var pool = ret;
            var ctx  = lctx.context,
                step = lctx.step;

            if(ctx == null || step == null) { return; }
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.profile.push(step);
        });
};

var checkedSql = new IntKeyMap(2000).setMax(2000);
var nonLiteSql = new IntKeyMap(5000).setMax(5000);
var date = DateUtil.yyyymmdd();

function escapeLiteral(sql) {
    if(sql == null) { sql = ''; }

    if(date !== DateUtil.yyyymmdd()) {
        checkedSql.clear();
        nonLiteSql.clear();
        date = DateUtil.yyyymmdd();
        Logger.print('WHATAP-SQL-CLEAR', 'MssqlObserver CLEAR OK!!!!!!!!!!!!!!!!', false);
    }

    var sqlHash = HashUtil.hashFromString(sql);
    var psql = nonLiteSql.get(sqlHash);

    if(psql != null) {
        return psql;
    }
    psql = checkedSql.get(sqlHash);

    if(psql != null) {
        return psql;
    }

    var els = new EscapeLiteralSQL(sql);
    els.process();

    var hash = HashUtil.hashFromString(els.getParsedSql());
    DataTextAgent.SQL.add(hash, els.getParsedSql());

    if(hash === sqlHash) {
        psql = new ParsedSql(els.sqlType, hash, null);
        nonLiteSql.put(sqlHash, psql);
    } else {
        psql = new ParsedSql(els.sqlType, hash, els.getParameter());
        checkedSql.put(sqlHash, psql);
    }
    return psql;
}

exports.MssqlObserver = MssqlObserver;