
var TraceContextManager = require('../trace/trace-context-manager'),
    SqlStepX            = require('../step/sql-stepx'),
    DataTextAgent       = require('../data/datatext-agent'),
    HashUtil            = require('../util/hashutil');
const DBCStep = require("whatap/lib/step/dbc-step");
const Logger = require("whatap/lib/logger");

var MongooseObserver = function (agent) {
    this.agent = agent;
    this.packages = ['mongoose'];
};

var dbc_step, dbc, conn_dbc_hash;
MongooseObserver.prototype.inject = function (mod, modName) {

    var self = this;
    var hookCommand = [
        "create",             // Create: Create a new document
        "insertMany",         // Create: Create multiple documents at once
        "find",               // Read: Find documents that match criteria
        "findById",           // Read: Find a document by its ID
        "findOne",            // Read: Find the first document that matches criteria
        "countDocuments",     // Read: Count the number of documents that match criteria
        "distinct",           // Read: Find distinct values for a given field
        "updateMany",         // Update: Update multiple documents that match criteria
        "updateOne",          // Update: Update a single document that matches criteria
        "replaceOne",         // Update: Replace one document with another
        "findOneAndUpdate",   // Update: Find the first document that matches criteria and update it
        "findByIdAndUpdate",  // Update: Find a document by its ID and update it
        "deleteOne",          // Delete: Delete a single document that matches criteria
        "deleteMany",         // Delete: Delete multiple documents that match criteria
        "findOneAndDelete",   // Delete: Find the first document that matches criteria and delete it
        "findByIdAndDelete"   // Delete: Find a document by its ID and delete it
    ];

    self.agent.aop.after(mod, ['connect'] ,function (obj, args, ret) {
        if(!args[0]) { return; }
        if(dbc) { return; }
        dbc = args[0];
        conn_dbc_hash = HashUtil.hashFromString(dbc);

        ret.then(data => {
            self.agent.aop.both(data.Model, 'aggregate', function (_obj, _args, _lctx) {
                var ctx = TraceContextManager.getCurrentContext();
                if(!ctx) {return;}

                if(dbc && conn_dbc_hash){
                    DataTextAgent.DBC.add(conn_dbc_hash, dbc);
                    DataTextAgent.METHOD.add(conn_dbc_hash, dbc);
                    DataTextAgent.ERROR.add(conn_dbc_hash, dbc);
                }

                var dbc_step = new DBCStep();
                dbc_step.hash = conn_dbc_hash;
                dbc_step.start_time = ctx.getElapsedTime();

                _lctx.dbc_step = dbc_step;

                var sql_step = new SqlStepX();
                sql_step.start_time = ctx.getElapsedTime();
                _lctx.sql_step = sql_step;
            }, function (_obj, _args, _ret, _lctx) {
                var ctx = _lctx.context;
                var dbc_step = _lctx.dbc_step;
                var sql_step = _lctx.sql_step;
                if(!ctx || !dbc_step || !sql_step) {return null;}

                dbc_step.elapsed = ctx.getElapsedTime() - dbc_step.start_time;
                ctx.profile.push(dbc_step);

                ctx.footprint('Mongodb Command Start: ' + _ret.op );

                const mongooseCollection = _ret._model;
                try {
                    var sql = mongooseCollection.modelName + ' aggregate';
                    var param = "";
                    if(Array.isArray(_args[0])) {
                        _args[0].forEach(function (val, i) {
                            if(i > 0 && param.length > 0) {
                                param += ",";
                            }
                            if(val.hasOwnProperty('$match')) {
                                var keys = Object.keys(val['$match']);
                                param += keys;
                            }

                            if(val.hasOwnProperty('$group')) {
                                var keys = Object.keys(val['$group']);
                                param += keys;
                            }
                        })
                    }
                    sql += ' field=['+param+']';

                    sql_step.hash = HashUtil.hashFromString(sql);
                    sql_step.start_time = ctx.getElapsedTime();
                    sql_step.elapsed = ctx.getElapsedTime() - sql_step.start_time;
                    DataTextAgent.SQL.add(sql_step.hash, sql);
                    ctx.profile.push(sql_step);
                } catch(e) {
                    Logger.printError("WHATAP-611", "Mongodb query error", e, false);
                    sql_step = null;
                }
            });

            self.agent.aop.both(data.Model, hookCommand, function (_obj, _args, _lctx) {
                if(_args[0] && typeof _args[0] !== "object") { return; }
                const ctx = TraceContextManager.getCurrentContext();
                if(!ctx) { return; }
                if(dbc && conn_dbc_hash){
                    DataTextAgent.DBC.add(conn_dbc_hash, dbc);
                    DataTextAgent.METHOD.add(conn_dbc_hash, dbc);
                    DataTextAgent.ERROR.add(conn_dbc_hash, dbc);
                }

                var dbc_step = new DBCStep();
                dbc_step.hash = conn_dbc_hash;
                dbc_step.start_time = ctx.getElapsedTime();

                _lctx.dbc_step = dbc_step;

                var sql_step = new SqlStepX();
                sql_step.start_time = ctx.getElapsedTime();
                _lctx.sql_step = sql_step;
            }, function (_obj, _args, _ret, _lctx) {
                var ctx = _lctx.context;
                var dbc_step = _lctx.dbc_step;
                var sql_step = _lctx.sql_step;
                if(!ctx || !dbc_step || !sql_step) {return null;}

                dbc_step.elapsed = ctx.getElapsedTime() - dbc_step.start_time;
                ctx.profile.push(dbc_step);

                ctx.footprint('Mongodb Command Start: ' + _ret.op );

                const mongooseCollection = _ret.mongooseCollection;
                try {
                    if(mongooseCollection && mongooseCollection.modelName){
                        var sql = mongooseCollection.modelName + ' ' + _ret.op;//+ ': ' + JSON.stringify(Object.keys(args[0]));
                        if (_args[0]) {
                            sql += ' field=' + JSON.stringify(Object.keys(_args[0]));
                        }
                        if (_args[1]) {
                            sql += ' value=' + JSON.stringify(Object.keys(_args[1]));
                        }

                        sql_step.hash = HashUtil.hashFromString(sql);
                        sql_step.start_time = ctx.getElapsedTime();
                        sql_step.elapsed = ctx.getElapsedTime() - sql_step.start_time;
                        DataTextAgent.SQL.add(sql_step.hash, sql);
                        ctx.profile.push(sql_step);
                    }
                } catch(e) {
                    Logger.printError("WHATAP-611", "Mongodb query error", e, false);
                    sql_step = null;
                }
            })
        }).catch(e => {
            Logger.printError("WHATAP-612", "Mongodb connection error", e, false);
        })
    })

};

exports.MongooseObserver = MongooseObserver;