
var TraceContextManager = require('../trace/trace-context-manager'),
    SqlStepX            = require('../step/sql-stepx'),
    DBCStep             = require('../step/dbc-step'),
    DataTextAgent       = require('../data/datatext-agent'),
    HashUtil            = require('../util/hashutil');

var MemcachedObserver = function (agent) {
    this.agent = agent;
    this.aop = agent.aop;
    this.packages = ['memcached'];
};

var commands = [
    'get',
    'gets',
    'getMulti',
    'set',
    'replace',
    'add',
    'cas',
    'append',
    'prepend',
    'increment',
    'decrement',
    'incr',
    'decr',
    'del',
    'delete',
    'version',
    'flush',
    'samples',
    'slabs',
    'items',
    'flushAll',
    'statsSettings',
    'statsSlabs',
    'statsItems',
    'cachedump'
];

MemcachedObserver.prototype.inject = function (mod, modName) {

    var self = this;
    if(mod.__whatap_observe__) {return;}
    mod.__whatap_observe__ = true;

    commands.forEach(function (command) {
        self.aop.before(mod.prototype, command, function (obj, args) {
            
        });
    });
};


exports.MemcachedObserver = MemcachedObserver;