/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Sender      = require('./sender'),
    Receiver    = require('./receiver'),
    conf        = require('./../conf/configure'),
    Logger      = require('../logger'),
    RequestDoubleQueue = require('./../util/requestdouble-queue');

var TcpRequestManager = function(agent){
    if(TcpRequestManager.instance === 'object') {
        return TcpRequestManager.instance;
    }

    this.agent = agent;
    this.sender1 = new Sender(agent, this);
    this.sender2 = new Sender(agent, this);
    this.receiver = new Receiver(agent, this);
    this.pool = new RequestDoubleQueue(conf.net_send_queue1_size, conf.net_send_queue2_size);
    this.sendDropped = 0;
    this.isExistData = false;

    TcpRequestManager.instance = this;
};
TcpRequestManager.prototype.add = function(flag, p){
    var _this = this;
    var ok = this.pool.put1({flag: flag, pack: p});
    if(ok === false){
        this.sendDropped++;
        Logger.print("WHATAP-201", 'Data[1] drop count : ' + this.sendDropped)
    } else {
        process.nextTick(function () {
            _this.notify();
        });
    }
};
TcpRequestManager.prototype.addProfile = function(flag, p) {
    var self = this;
    var ok = this.pool.put2({flag: flag, pack: p});

    if(ok === false){
        this.sendDropped++;
        Logger.print("WHATAP-201", 'Data[2] drop count : ' + this.sendDropped)
    }else{
        process.nextTick(function () {
            self.notify();
        });
    }
};
TcpRequestManager.prototype.notify = function(){
    this.sender1.startCheckQueue();
    this.sender2.startCheckQueue();
};

module.exports = new TcpRequestManager();