var net             = require('net'),
    DataOutputX     = require('../io/data-outputx'),
    DataInputX      = require('../io/data-inputx'),
    Logger          = require('../logger')
;
var READ_MAX = 8 * 1024 * 1024;

var TcpRequestClientProxy = function(msg){
    this.msg = msg;
    this.failConLog = true;
}

TcpRequestClientProxy.prototype.close = function(){
    if(!this.client) return;

    this.client.destroy();
    this.client = undefined;
}

TcpRequestClientProxy.prototype.isOpen = function(){

}

TcpRequestClientProxy.prototype.send = function(din){
    if(!this.client) return;

    var out = new DataOutputX();
    out.write(ss(0XCAFE));
    out.writeIntBytes(din.toByteArray())

    this.client.write( out.toByteArray()
        , function(error, data){
            if(error){
                return Logger.printError('WHATAP-996', 'TcpRequestClientProxy (send)', e, true);
            }
        }
    );
}

TcpRequestClientProxy.prototype.open = function(host, port, connectCb, dataCb){
    var self = this;

    this.client = net.connect({host: host, port: port}, connectCb);
    this.client.on('data', function(data) {
        var din = new DataInputX(data);
        var cafe = din.readUInt16BE();
        var bytes = din.readIntBytes(READ_MAX);

        if(dataCb) dataCb(undefined, bytes);
        self.close();
    });

    this.client.on('error', function (err) {
        Logger.printError("WHATAP-128", 'Failed to connect to ' + self.msg , err, true);        
        if(dataCb) dataCb(err);
    });

    this.client.on('close', function() {
        self.close();
    });
}

function ss(v) {
    var buf = new Array(2);
    buf[0] = ((v >>> 8) & 0xFF);
    buf[1] = ((v >>> 0) & 0xFF);
    return buf;
};

module.exports = TcpRequestClientProxy;